/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.ws.impl;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.TimedValue;

class NotificationSnapshot {
    public ProviderSnapshot provider;
    public ServiceSnapshot service;
    public ResourceSnapshot resource;
    private final Instant timestamp;
    private final AbstractResourceNotification notification;

    public NotificationSnapshot(LifecycleNotification notif) {
        this.notification = notif;
        this.timestamp = Instant.now();
        this.provider = new ProviderSnapshotImpl();
        this.service = new ServiceSnapshotImpl();
        this.resource = new ResourceSnapshotImpl(notif.initialValue);
    }

    public NotificationSnapshot(ResourceDataNotification notif) {
        this.notification = notif;
        this.timestamp = notif.timestamp;
        this.provider = new ProviderSnapshotImpl();
        this.service = new ServiceSnapshotImpl();
        this.resource = new ResourceSnapshotImpl(notif.newValue);
    }

    public String toString() {
        return this.resource.toString();
    }

    private class ProviderSnapshotImpl
    implements ProviderSnapshot {
        private ProviderSnapshotImpl() {
        }

        public String getName() {
            return NotificationSnapshot.this.notification.provider;
        }

        public Instant getSnapshotTime() {
            return NotificationSnapshot.this.timestamp;
        }

        public String getModelName() {
            return NotificationSnapshot.this.notification.model;
        }

        public List<ServiceSnapshot> getServices() {
            return List.of(NotificationSnapshot.this.service);
        }
    }

    private class ServiceSnapshotImpl
    implements ServiceSnapshot {
        private ServiceSnapshotImpl() {
        }

        public String getName() {
            return NotificationSnapshot.this.notification.service;
        }

        public Instant getSnapshotTime() {
            return NotificationSnapshot.this.timestamp;
        }

        public ProviderSnapshot getProvider() {
            return NotificationSnapshot.this.provider;
        }

        public List<ResourceSnapshot> getResources() {
            return List.of(NotificationSnapshot.this.resource);
        }
    }

    private class ResourceSnapshotImpl
    implements ResourceSnapshot {
        private final TimedValue<?> value;

        public ResourceSnapshotImpl(final Object value) {
            this.value = new TimedValue<Object>(){

                public Instant getTimestamp() {
                    return NotificationSnapshot.this.timestamp;
                }

                public Object getValue() {
                    return value;
                }
            };
        }

        public String toString() {
            return String.format("ResourceNotif(%s/%s/%s=%s @ %s)", NotificationSnapshot.this.notification.provider, NotificationSnapshot.this.notification.service, NotificationSnapshot.this.notification.resource, this.value.getValue(), NotificationSnapshot.this.timestamp);
        }

        public String getName() {
            return NotificationSnapshot.this.notification.resource;
        }

        public Instant getSnapshotTime() {
            return this.value.getTimestamp();
        }

        public ServiceSnapshot getService() {
            return NotificationSnapshot.this.service;
        }

        public boolean isSet() {
            return true;
        }

        public TimedValue<?> getValue() {
            return this.value;
        }

        public Map<String, Object> getMetadata() {
            return Map.of();
        }

        public ResourceType getResourceType() {
            return ResourceType.PROPERTY;
        }

        public ValueType getValueType() {
            return ValueType.UPDATABLE;
        }
    }
}

