/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.impl.SensiNactSessionImpl;
import org.eclipse.sensinact.core.metrics.IMetricsGauge;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.security.UserInfo;
import org.eclipse.sensinact.core.session.SensiNactSession;
import org.eclipse.sensinact.core.session.SensiNactSessionManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.typedevent.TypedEventHandler;
import org.osgi.service.typedevent.propertytypes.EventTopics;

@Component(property={"sensinact.metrics.gauge.name=sensinact.sessions"})
@EventTopics(value={"LIFECYCLE/*", "METADATA/*", "DATA/*", "ACTION/*"})
public class SessionManager
implements SensiNactSessionManager,
TypedEventHandler<AbstractResourceNotification>,
IMetricsGauge {
    @Reference
    GatewayThread thread;
    private final Object lock = new Object();
    private final Map<String, SensiNactSessionImpl> sessions = new HashMap<String, SensiNactSessionImpl>();
    private final Map<String, Set<String>> sessionsByUser = new HashMap<String, Set<String>>();
    private final Map<String, String> userDefaultSessionIds = new HashMap<String, String>();

    public Object gauge() {
        return this.sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensiNactSession getDefaultSession(UserInfo user) {
        String sessionId;
        Objects.requireNonNull(user);
        SensiNactSession session = null;
        String userId = user.getUserId();
        Object object = this.lock;
        synchronized (object) {
            sessionId = this.userDefaultSessionIds.get(userId);
            if (sessionId != null) {
                session = this.sessions.get(sessionId);
            }
        }
        if (session == null) {
            if (sessionId != null) {
                this.removeSession(userId, sessionId);
            }
            session = this.createNewSession(user);
            sessionId = session.getSessionId();
            object = this.lock;
            synchronized (object) {
                sessionId = this.userDefaultSessionIds.putIfAbsent(userId, sessionId);
            }
            if (sessionId != null) {
                this.removeSession(userId, session.getSessionId());
                session.expire();
                return this.getSession(user, sessionId);
            }
        } else if (session.isExpired()) {
            this.removeSession(userId, sessionId);
            session = this.getDefaultSession(user);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(String userId, String sessionId) {
        Object object = this.lock;
        synchronized (object) {
            this.userDefaultSessionIds.remove(userId, sessionId);
            this.sessionsByUser.computeIfPresent(userId, (k, v) -> v.stream().filter(s -> !s.equals(sessionId)).collect(Collectors.toCollection(LinkedHashSet::new)));
            this.sessions.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensiNactSession getSession(UserInfo user, String sessionId) {
        Objects.requireNonNull(user);
        SensiNactSessionImpl session = null;
        String userId = user.getUserId();
        Object object = this.lock;
        synchronized (object) {
            if (this.sessionsByUser.getOrDefault(userId, Set.of()).contains(sessionId)) {
                session = this.sessions.get(sessionId);
            }
        }
        if (session != null && session.isExpired()) {
            this.removeSession(userId, sessionId);
            session = null;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSessionIds(UserInfo user) {
        List<String> ids;
        Objects.requireNonNull(user);
        String userId = user.getUserId();
        Object object = this.lock;
        synchronized (object) {
            ids = this.sessionsByUser.getOrDefault(userId, Set.of()).stream().collect(Collectors.toList());
        }
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            SensiNactSession session;
            String sessionId = (String)it.next();
            Object object2 = this.lock;
            synchronized (object2) {
                session = this.sessions.get(sessionId);
            }
            if (session != null && !session.isExpired()) continue;
            this.removeSession(userId, sessionId);
            it.remove();
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensiNactSession createNewSession(UserInfo user) {
        Objects.requireNonNull(user);
        SensiNactSessionImpl session = new SensiNactSessionImpl(user, this.thread);
        String sessionId = session.getSessionId();
        Object object = this.lock;
        synchronized (object) {
            this.sessionsByUser.merge(user.getUserId(), Set.of(sessionId), (a, b) -> Stream.concat(b.stream(), a.stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
            this.sessions.put(sessionId, session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(String topic, AbstractResourceNotification event) {
        ArrayList<SensiNactSessionImpl> sessions;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            sessions = new ArrayList<SensiNactSessionImpl>(this.sessions.values());
        }
        for (SensiNactSessionImpl session : sessions) {
            if (!session.isExpired()) {
                try {
                    session.notify(topic, event);
                }
                catch (Exception exception) {}
                continue;
            }
            this.removeSession(session.getUserInfo().getUserId(), session.getSessionId());
        }
    }

    public SensiNactSession getDefaultAnonymousSession() {
        return this.getDefaultSession(UserInfo.ANONYMOUS);
    }

    public SensiNactSession getAnonymousSession(String sessionId) {
        return this.getSession(UserInfo.ANONYMOUS, sessionId);
    }

    public List<String> getAnonymousSessionIds() {
        return this.getSessionIds(UserInfo.ANONYMOUS);
    }

    public SensiNactSession createNewAnonymousSession() {
        return this.createNewSession(UserInfo.ANONYMOUS);
    }
}

