/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.impl;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.model.core.metadata.ResourceAttribute;

public class ResourceImpl
extends CommandScopedImpl
implements Resource {
    private final Service service;
    private final ETypedElement feature;

    public ResourceImpl(AtomicBoolean active, Service service, ETypedElement feature) {
        super(active);
        this.service = service;
        this.feature = feature;
    }

    public String getName() {
        this.checkValid();
        return this.feature.getName();
    }

    public boolean isExclusivelyOwned() {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public boolean isAutoDelete() {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public Class<?> getType() {
        this.checkValid();
        return this.feature.getEType().getInstanceClass();
    }

    public ValueType getValueType() {
        this.checkValid();
        throw new RuntimeException("Not implemented");
    }

    public ResourceType getResourceType() {
        this.checkValid();
        return ResourceImpl.findResourceType(this.feature);
    }

    public static ResourceType findResourceType(ETypedElement feature) {
        if (feature instanceof EOperation) {
            return ResourceType.ACTION;
        }
        if (feature instanceof ResourceAttribute) {
            return ResourceType.valueOf((String)((ResourceAttribute)feature).getResourceType().getName());
        }
        return ResourceType.PROPERTY;
    }

    public List<Map.Entry<String, Class<?>>> getArguments() {
        this.checkValid();
        if (this.getResourceType() != ResourceType.ACTION) {
            throw new IllegalArgumentException("This is not an action resource");
        }
        return ResourceImpl.findActionParameters((EOperation)this.feature);
    }

    public static List<Map.Entry<String, Class<?>>> findActionParameters(EOperation operation) {
        List<Map.Entry<String, Class<?>>> result = operation.getEParameters().stream().map(ep -> new AbstractMap.SimpleImmutableEntry<String, Class>(ep.getName(), ep.getEType().getInstanceClass())).collect(Collectors.toList());
        return result;
    }

    public Service getService() {
        this.checkValid();
        return this.service;
    }

    public static ValueType findValueType(ETypedElement feature) {
        if (feature instanceof ResourceAttribute) {
            return ValueType.valueOf((String)((ResourceAttribute)feature).getValueType().getName());
        }
        throw new UnsupportedOperationException("Handling of none Sensinact Atributes not implemented yet");
    }
}

