/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.twin.impl;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFDigitalTwin;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFProvider;
import org.eclipse.sensinact.core.impl.snapshot.ProviderSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ResourceSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ServiceSnapshotImpl;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.twin.impl.SensinactProviderImpl;
import org.eclipse.sensinact.core.twin.impl.SensinactResourceImpl;
import org.eclipse.sensinact.core.twin.impl.SensinactServiceImpl;
import org.eclipse.sensinact.core.twin.impl.TimedValueImpl;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.osgi.util.promise.PromiseFactory;

public class SensinactDigitalTwinImpl
extends CommandScopedImpl
implements SensinactEMFDigitalTwin {
    private final ModelNexus nexusImpl;
    private final PromiseFactory pf;

    public SensinactDigitalTwinImpl(ModelNexus nexusImpl, PromiseFactory pf) {
        super(new AtomicBoolean(true));
        this.nexusImpl = nexusImpl;
        this.pf = pf;
    }

    public List<SensinactProviderImpl> getProviders() {
        this.checkValid();
        return this.nexusImpl.getProviders().stream().map(this::toProvider).collect(Collectors.toList());
    }

    public SensinactProviderImpl getProvider(EClass model, String id) {
        if (model != ProviderPackage.Literals.PROVIDER || !model.getEAllSuperTypes().contains((Object)ProviderPackage.Literals.PROVIDER)) {
            throw new IllegalArgumentException("The requested eClass must have Provider as a super class");
        }
        Provider provider = this.nexusImpl.getProvider(model, id);
        if (provider == null) {
            return null;
        }
        return this.toProvider(provider);
    }

    public List<SensinactProviderImpl> getProviders(String model) {
        this.checkValid();
        return this.nexusImpl.getProviders(model).stream().map(this::toProvider).collect(Collectors.toList());
    }

    public SensinactProviderImpl getProvider(String model, String providerName) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(model, providerName);
        if (provider == null) {
            return null;
        }
        return this.toProvider(provider);
    }

    public SensinactProviderImpl getProvider(String providerName) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(providerName);
        if (provider == null) {
            return null;
        }
        return this.toProvider(provider);
    }

    public SensinactEMFProvider createProvider(String model, String providerName) {
        return this.toProvider(this.nexusImpl.createProviderInstance(model, providerName));
    }

    public SensinactEMFProvider createProvider(String model, String providerName, Instant instant) {
        return instant == null ? this.createProvider(model, providerName) : this.toProvider(this.nexusImpl.createProviderInstance(model, providerName, instant));
    }

    public SensinactServiceImpl getService(String model, String providerName, String service) {
        this.checkValid();
        return this.getService(this.nexusImpl.getProvider(model, providerName), model, service);
    }

    public SensinactServiceImpl getService(String providerName, String service) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(providerName);
        return this.getService(provider, this.nexusImpl.getProviderModel(providerName), service);
    }

    private SensinactServiceImpl getService(Provider provider, String model, String service) {
        if (provider == null) {
            return null;
        }
        EStructuralFeature svcFeature = provider.eClass().getEStructuralFeature(service);
        if (svcFeature == null) {
            return null;
        }
        SensinactProviderImpl snProvider = this.toProvider(provider);
        return this.toService((SensinactProvider)snProvider, provider, (EReference)svcFeature);
    }

    public SensinactResourceImpl getResource(String model, String providerName, String service, String resource) {
        this.checkValid();
        return this.getResource(this.nexusImpl.getProvider(model, providerName), model, service, resource);
    }

    public SensinactResourceImpl getResource(String providerName, String service, String resource) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(providerName);
        return this.getResource(provider, this.nexusImpl.getProviderModel(providerName), service, resource);
    }

    private SensinactResourceImpl getResource(Provider provider, String model, String service, String resource) {
        if (provider == null) {
            return null;
        }
        EReference svcFeature = (EReference)provider.eClass().getEStructuralFeature(service);
        if (svcFeature == null) {
            return null;
        }
        EClass serviceEClass = svcFeature.getEReferenceType();
        ETypedElement rcFeature = Optional.ofNullable(serviceEClass.getEStructuralFeature(resource)).map(ETypedElement.class::cast).or(() -> serviceEClass.getEOperations().stream().filter(o -> o.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(o -> resource.equals(o.getName())).map(ETypedElement.class::cast).findFirst()).orElseGet(() -> null);
        if (rcFeature == null) {
            return null;
        }
        SensinactProviderImpl snProvider = this.toProvider(provider);
        SensinactServiceImpl snSvc = this.toService((SensinactProvider)snProvider, provider, svcFeature);
        return this.toResource(snSvc, provider, svcFeature, rcFeature);
    }

    public <T> TimedValue<T> getResourceValue(String model, String providerName, String service, String resource, Class<T> type) {
        this.checkValid();
        return this.getResourceValue(this.nexusImpl.getProvider(model, providerName), service, resource, type);
    }

    public <T> TimedValue<T> getResourceValue(String providerName, String service, String resource, Class<T> type) {
        this.checkValid();
        return this.getResourceValue(this.nexusImpl.getProvider(providerName), service, resource, type);
    }

    private <T> TimedValue<T> getResourceValue(Provider provider, String service, String resource, Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Resource type must not be null");
        }
        if (provider == null) {
            return null;
        }
        EStructuralFeature svcFeature = provider.eClass().getEStructuralFeature(service);
        if (svcFeature == null) {
            return null;
        }
        Service svc = (Service)provider.eGet(svcFeature);
        EStructuralFeature rcFeature = svc.eClass().getEStructuralFeature(resource);
        if (rcFeature == null) {
            return null;
        }
        Metadata metadata = (Metadata)svc.getMetadata().get((Object)rcFeature);
        Instant timestamp = metadata != null ? metadata.getTimestamp() : null;
        Object rawValue = svc.eGet(rcFeature);
        if (rawValue == null) {
            return new TimedValueImpl<Object>(null, timestamp);
        }
        if (!type.isAssignableFrom(rawValue.getClass())) {
            throw new IllegalArgumentException("Expected a " + type.getName() + " but resource is a " + rawValue.getClass().getName());
        }
        return new TimedValueImpl<T>(type.cast(rawValue), timestamp);
    }

    private SensinactProviderImpl toProvider(Provider modelProvider) {
        return new SensinactProviderImpl(this.active, modelProvider, this.nexusImpl, this.pf);
    }

    private SensinactServiceImpl toService(SensinactProvider parent, Provider provider, EReference ref) {
        return new SensinactServiceImpl(this.active, parent, provider, ref, this.nexusImpl, this.pf);
    }

    private SensinactResourceImpl toResource(SensinactService parent, Provider provider, EReference svcFeature, ETypedElement rcFeature) {
        return new SensinactResourceImpl(this.active, parent, provider, svcFeature, rcFeature, rcFeature.getEType().getInstanceClass(), this.nexusImpl, this.pf);
    }

    private void fillInResource(ResourceSnapshotImpl rcSnapshot) {
        if (rcSnapshot.getResourceType() == ResourceType.ACTION) {
            return;
        }
        ETypedElement rcFeature = rcSnapshot.getFeature();
        Service svc = rcSnapshot.getService().getModelService();
        if (!svc.eIsSet((EStructuralFeature)rcFeature)) {
            return;
        }
        Metadata metadata = svc == null ? null : (Metadata)svc.getMetadata().get((Object)rcFeature);
        Instant timestamp = metadata != null ? metadata.getTimestamp() : null;
        rcSnapshot.setValue(new TimedValueImpl<Object>((svc == null ? null : svc.eGet((EStructuralFeature)rcFeature)), timestamp));
    }

    public List<ProviderSnapshot> filteredSnapshot(Predicate<GeoJsonObject> geoFilter, Predicate<ProviderSnapshot> providerFilter, Predicate<ServiceSnapshot> svcFilter, Predicate<ResourceSnapshot> rcFilter) {
        Instant snapshotTime = Instant.now();
        Stream<Provider> rawProvidersStream = this.nexusImpl.getProviders().stream();
        if (geoFilter != null) {
            rawProvidersStream = rawProvidersStream.filter(p -> geoFilter.test(p.getAdmin().getLocation()));
        }
        Stream<ProviderSnapshotImpl> providersStream = rawProvidersStream.map(p -> new ProviderSnapshotImpl(this.nexusImpl.getProviderModel(p.getId()), (Provider)p, snapshotTime));
        if (providerFilter != null) {
            providersStream = providersStream.filter(providerFilter);
        }
        providersStream = providersStream.map(p -> {
            Provider modelProvider = p.getModelProvider();
            this.nexusImpl.getServicesForModel(modelProvider.eClass()).filter(arg_0 -> ((Provider)modelProvider).eIsSet(arg_0)).forEach(feature -> p.add(new ServiceSnapshotImpl((ProviderSnapshotImpl)p, feature.getName(), (Service)modelProvider.eGet((EStructuralFeature)feature), snapshotTime)));
            return p;
        });
        if (svcFilter != null) {
            providersStream = providersStream.filter(p -> p.getServices().stream().anyMatch(svcFilter));
        }
        providersStream = providersStream.map(p -> {
            p.getServices().stream().forEach(s -> {
                EStructuralFeature sf = s.getProvider().getModelProvider().eClass().getEStructuralFeature(s.getName());
                this.nexusImpl.getResourcesForService((EClass)sf.getEType()).forEach(f -> s.add(new ResourceSnapshotImpl((ServiceSnapshotImpl)s, (ETypedElement)f, snapshotTime)));
            });
            return p;
        });
        if (rcFilter != null) {
            providersStream = providersStream.filter(p -> p.getServices().stream().anyMatch(s -> s.getResources().stream().anyMatch(rcFilter)));
        }
        providersStream = providersStream.map(p -> {
            p.getServices().stream().forEach(s -> s.getResources().stream().forEach(this::fillInResource));
            p.filterEmptyServices();
            return p;
        });
        return providersStream.collect(Collectors.toList());
    }

    public ProviderSnapshot snapshotProvider(String providerName) {
        Instant snapshotTime = Instant.now();
        Provider nexusProvider = this.nexusImpl.getProvider(providerName);
        if (nexusProvider == null) {
            return null;
        }
        ProviderSnapshotImpl providerSnapshot = new ProviderSnapshotImpl(this.nexusImpl.getProviderModel(nexusProvider.getId()), nexusProvider, snapshotTime);
        this.nexusImpl.getServicesForModel(nexusProvider.eClass()).filter(arg_0 -> ((Provider)nexusProvider).eIsSet(arg_0)).forEach(svcFeature -> {
            ServiceSnapshotImpl svcSnapshot = new ServiceSnapshotImpl(providerSnapshot, svcFeature.getName(), (Service)nexusProvider.eGet((EStructuralFeature)svcFeature), snapshotTime);
            EStructuralFeature sf = nexusProvider.eClass().getEStructuralFeature(svcSnapshot.getName());
            this.nexusImpl.getResourcesForService((EClass)sf.getEType()).forEach(rcFeature -> {
                ResourceSnapshotImpl rcSnapshot = new ResourceSnapshotImpl(svcSnapshot, (ETypedElement)rcFeature, snapshotTime);
                this.fillInResource(rcSnapshot);
                svcSnapshot.add(rcSnapshot);
            });
            providerSnapshot.add(svcSnapshot);
        });
        providerSnapshot.filterEmptyServices();
        return providerSnapshot;
    }

    public ServiceSnapshot snapshotService(String providerName, String serviceName) {
        Instant snapshotTime = Instant.now();
        Provider nexusProvider = this.nexusImpl.getProvider(providerName);
        if (nexusProvider == null) {
            return null;
        }
        Optional<EReference> foundSvc = this.nexusImpl.getServicesForModel(nexusProvider.eClass()).filter(arg_0 -> ((Provider)nexusProvider).eIsSet(arg_0)).filter(f -> f.getName().equals(serviceName)).findFirst();
        if (foundSvc.isEmpty()) {
            return null;
        }
        ProviderSnapshotImpl providerSnapshot = new ProviderSnapshotImpl(this.nexusImpl.getProviderModel(nexusProvider.getId()), nexusProvider, snapshotTime);
        EReference svcFeature = foundSvc.get();
        ServiceSnapshotImpl svcSnapshot = new ServiceSnapshotImpl(providerSnapshot, svcFeature.getName(), (Service)nexusProvider.eGet((EStructuralFeature)svcFeature), snapshotTime);
        providerSnapshot.add(svcSnapshot);
        EStructuralFeature sf = nexusProvider.eClass().getEStructuralFeature(svcSnapshot.getName());
        this.nexusImpl.getResourcesForService((EClass)sf.getEType()).forEach(rcFeature -> {
            ResourceSnapshotImpl rcSnapshot = new ResourceSnapshotImpl(svcSnapshot, (ETypedElement)rcFeature, snapshotTime);
            this.fillInResource(rcSnapshot);
            svcSnapshot.add(rcSnapshot);
        });
        return svcSnapshot;
    }

    public ResourceSnapshot snapshotResource(String providerName, String serviceName, String resourceName) {
        Instant snapshotTime = Instant.now();
        Provider nexusProvider = this.nexusImpl.getProvider(providerName);
        if (nexusProvider == null) {
            return null;
        }
        Optional<EReference> foundSvc = this.nexusImpl.getServicesForModel(nexusProvider.eClass()).filter(arg_0 -> ((Provider)nexusProvider).eIsSet(arg_0)).filter(f -> f.getName().equals(serviceName)).findFirst();
        if (foundSvc.isEmpty()) {
            return null;
        }
        EStructuralFeature sf = nexusProvider.eClass().getEStructuralFeature(serviceName);
        Optional<ETypedElement> foundRc = this.nexusImpl.getResourcesForService((EClass)sf.getEType()).filter(f -> f.getName().equals(resourceName)).findFirst();
        if (foundRc.isEmpty()) {
            return null;
        }
        ProviderSnapshotImpl providerSnapshot = new ProviderSnapshotImpl(this.nexusImpl.getProviderModel(nexusProvider.getId()), nexusProvider, snapshotTime);
        EReference svcFeature = foundSvc.get();
        ServiceSnapshotImpl svcSnapshot = new ServiceSnapshotImpl(providerSnapshot, svcFeature.getName(), (Service)nexusProvider.eGet((EStructuralFeature)svcFeature), snapshotTime);
        providerSnapshot.add(svcSnapshot);
        ResourceSnapshotImpl rcSnapshot = new ResourceSnapshotImpl(svcSnapshot, foundRc.get(), snapshotTime);
        this.fillInResource(rcSnapshot);
        svcSnapshot.add(rcSnapshot);
        return rcSnapshot;
    }
}

