/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.whiteboard.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.annotation.verb.ActParam;
import org.eclipse.sensinact.core.annotation.verb.UriParam;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;

abstract class AbstractResourceMethod {
    protected final Method method;
    protected final Object instance;
    final Long serviceId;
    final Set<String> providers;

    public AbstractResourceMethod(Method method, Object instance, Long serviceId, Set<String> providers) {
        this.method = method;
        this.instance = instance;
        this.serviceId = serviceId;
        this.providers = providers;
    }

    public boolean isCatchAll() {
        return this.providers.isEmpty();
    }

    public boolean overlaps(AbstractResourceMethod otherMethod) {
        return this.providers.isEmpty() && otherMethod.providers.isEmpty() || Collections.disjoint(this.providers, otherMethod.providers);
    }

    public List<Map.Entry<String, Class<?>>> getNamedParameterTypes() {
        return Arrays.stream(this.method.getParameters()).filter(p -> !p.isAnnotationPresent(UriParam.class)).map(p -> new AbstractMap.SimpleImmutableEntry(this.getActionParameterName((Parameter)p), p.getType())).collect(Collectors.toList());
    }

    private String getActionParameterName(Parameter p) {
        String name = p.isAnnotationPresent(ActParam.class) ? p.getAnnotation(ActParam.class).value() : p.getName();
        return name;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    protected <A extends Annotation, E extends Enum<E>> Object invoke(String model, String provider, String service, String resource, Map<Object, Object> params, Class<A> extraArgumentAnnotation, Function<A, E> argNameExtractor) throws Exception {
        Parameter[] parameters = this.method.getParameters();
        Object[] args = new Object[parameters.length];
        block7: for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            UriParam param = p.getAnnotation(UriParam.class);
            if (param != null) {
                switch (param.value()) {
                    case MODEL: {
                        args[i] = model;
                        continue block7;
                    }
                    case PROVIDER: {
                        args[i] = provider;
                        continue block7;
                    }
                    case RESOURCE: {
                        args[i] = resource;
                        continue block7;
                    }
                    case SERVICE: {
                        args[i] = service;
                        continue block7;
                    }
                    case URI: {
                        args[i] = String.format("%s/%s/%s/%s", model, provider, service, resource);
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException(param.value().toString());
                    }
                }
            }
            if (extraArgumentAnnotation != null) {
                A extraAnnotation = p.getAnnotation(extraArgumentAnnotation);
                E key = argNameExtractor.apply(extraAnnotation);
                args[i] = params.get(key);
                continue;
            }
            String name = this.getActionParameterName(p);
            Object o = params.get(name);
            args[i] = o == null ? null : (p.getType().isInstance(o) ? o : EMFUtil.convertToTargetType(p.getType(), o));
        }
        return this.method.invoke(this.instance, args);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[serviceId=" + this.serviceId + ", providers=" + this.providers + "]";
    }
}

