/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.DatastreamsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.SnapshotFilter;

public class DatastreamsAccessImpl
implements DatastreamsAccess {
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;
    @Context
    Application application;

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    public Datastream getDatastream(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return DtoMapper.toDatastream(userSession, this.getMapper(), this.uriInfo, userSession.describeResource(provider, service, resource));
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getDatastreamObservations(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return RootResourceAccessImpl.getObservationList(userSession, this.uriInfo, this.application, provider, service, resource);
    }

    public Observation getDatastreamObservation(String id, String id2) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        Observation o = DtoMapper.toObservation(this.uriInfo, userSession.describeResource(provider, service, resource));
        if (!id2.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Datastream getDatastreamObservationDatastream(String id, String id2) {
        return this.getDatastream(id);
    }

    public FeatureOfInterest getDatastreamObservationFeatureOfInterest(String id, String id2) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toFeatureOfInterest(userSession, this.uriInfo, this.getMapper(), provider);
    }

    public ObservedProperty getDatastreamObservedProperty(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        ObservedProperty o = DtoMapper.toObservedProperty(this.uriInfo, userSession.describeResource(provider, service, resource));
        if (!id.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public ResultList<Datastream> getDatastreamObservedPropertyDatastreams(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getDatastream(id));
        return list;
    }

    public Sensor getDatastreamSensor(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        Sensor s = DtoMapper.toSensor(this.uriInfo, userSession.describeResource(provider, service, resource));
        if (!id.equals(s.id)) {
            throw new NotFoundException();
        }
        return s;
    }

    public ResultList<Datastream> getDatastreamSensorDatastreams(String id) {
        return this.getDatastreamObservedPropertyDatastreams(id);
    }

    public Thing getDatastreamThing(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toThing(userSession, this.uriInfo, provider);
    }

    public ResultList<Datastream> getDatastreamThingDatastreams(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        ResultList list = new ResultList();
        list.value = userSession.filteredSnapshot((ICriterion)new SnapshotFilter(provider)).stream().flatMap(p -> p.getServices().stream()).flatMap(s -> s.getResources().stream()).map(r -> DtoMapper.toDatastream(this.getMapper(), this.uriInfo, r)).collect(Collectors.toList());
        return list;
    }

    public ResultList<HistoricalLocation> getDatastreamThingHistoricalLocations(String id) {
        HistoricalLocation hl;
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            hl = DtoMapper.toHistoricalLocation(userSession, this.getMapper(), this.uriInfo, provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }

    public ResultList<Location> getDatastreamThingLocations(String id) {
        Location hl;
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            hl = DtoMapper.toLocation(userSession, this.uriInfo, this.getMapper(), provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }
}

