/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.LocationsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.SnapshotFilter;

public class LocationsAccessImpl
implements LocationsAccess {
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(null);
    }

    public Location getLocation(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        Location l = DtoMapper.toLocation(this.getSession(), this.uriInfo, this.getMapper(), provider);
        if (!id.equals(l.id)) {
            throw new NotFoundException();
        }
        return l;
    }

    public ResultList<HistoricalLocation> getLocationHistoricalLocations(String id) {
        ResultList list = new ResultList();
        list.value = List.of(this.getLocationHistoricalLocation(id, id));
        return list;
    }

    public HistoricalLocation getLocationHistoricalLocation(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        HistoricalLocation hl = DtoMapper.toHistoricalLocation(this.getSession(), this.getMapper(), this.uriInfo, provider);
        if (!id2.equals(hl.id)) {
            throw new NotFoundException();
        }
        return hl;
    }

    public Thing getLocationHistoricalLocationsThing(String id, String id2) {
        if (!id2.equals(id)) {
            throw new NotFoundException();
        }
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toThing(this.getSession(), this.uriInfo, provider);
    }

    public ResultList<Location> getLocationHistoricalLocationLocations(String id, String id2) {
        ResultList list = new ResultList();
        list.value = List.of(this.getLocation(id));
        return list;
    }

    public ResultList<Thing> getLocationThings(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toThing(this.getSession(), this.uriInfo, provider));
        return list;
    }

    public Thing getLocationThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toThing(this.getSession(), this.uriInfo, provider);
    }

    public ResultList<Datastream> getLocationThingDatastreams(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        SensiNactSession userSession = this.getSession();
        ResultList list = new ResultList();
        list.value = userSession.filteredSnapshot((ICriterion)new SnapshotFilter(provider)).stream().flatMap(p -> p.getServices().stream()).flatMap(s -> s.getResources().stream()).map(r -> DtoMapper.toDatastream(this.getMapper(), this.uriInfo, r)).collect(Collectors.toList());
        return list;
    }

    public ResultList<HistoricalLocation> getLocationThingHistoricalLocations(String id, String id2) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.getMapper(), this.uriInfo, provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }

    public ResultList<Location> getLocationThingLocations(String id, String id2) {
        ResultList list = new ResultList();
        list.value = List.of(this.getLocation(id));
        return list;
    }
}

