/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.northbound.session.ResourceDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.FeatureOfInterest;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.ObservationsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.SnapshotFilter;

public class ObservationsAccessImpl
implements ObservationsAccess {
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;
    @Context
    Application application;

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(null);
    }

    public Observation getObservation(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        Instant timestamp = DtoMapper.getTimestampFromId(id);
        ResourceDescription description = this.getSession().describeResource(provider, service, resource);
        Observation result = null;
        if (description != null) {
            Instant milliTimestamp = description.timestamp.truncatedTo(ChronoUnit.MILLIS);
            if (timestamp.isBefore(milliTimestamp)) {
                TimedValue t;
                String history = (String)this.application.getProperties().get("sensinact.history.provider");
                if (history != null && timestamp.equals((t = (TimedValue)this.getSession().actOnResource(history, "history", "single", Map.of("provider", provider, "service", service, "resource", resource, "time", timestamp))).getTimestamp())) {
                    result = DtoMapper.toObservation(this.uriInfo, provider, service, resource, t);
                }
            } else if (timestamp.equals(milliTimestamp)) {
                result = DtoMapper.toObservation(this.uriInfo, description);
            }
        }
        if (result == null) {
            throw new NotFoundException();
        }
        return result;
    }

    public Datastream getObservationDatastream(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        Datastream d = DtoMapper.toDatastream(userSession, this.getMapper(), this.uriInfo, userSession.describeResource(provider, service, resource));
        if (!String.join((CharSequence)"~", provider, service, resource).equals(d.id)) {
            throw new NotFoundException();
        }
        return d;
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getObservationDatastreamObservations(String id) {
        SensiNactSession userSession = this.getSession();
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return RootResourceAccessImpl.getObservationList(userSession, this.uriInfo, this.application, provider, service, resource);
    }

    public ObservedProperty getObservationDatastreamObservedProperty(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return DtoMapper.toObservedProperty(this.uriInfo, this.getSession().describeResource(provider, service, resource));
    }

    public Sensor getObservationDatastreamSensor(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        String service = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id.substring(provider.length() + service.length() + 2));
        return DtoMapper.toSensor(this.uriInfo, this.getSession().describeResource(provider, service, resource));
    }

    public Thing getObservationDatastreamThing(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toThing(this.getSession(), this.uriInfo, provider);
    }

    public FeatureOfInterest getObservationFeatureOfInterest(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        return DtoMapper.toFeatureOfInterest(this.getSession(), this.uriInfo, this.getMapper(), provider);
    }

    public ResultList<Observation> getObservationFeatureOfInterestObservations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        DtoMapper.getTimestampFromId(id);
        SensiNactSession userSession = this.getSession();
        ResultList list = new ResultList();
        list.value = userSession.filteredSnapshot((ICriterion)new SnapshotFilter(provider)).stream().flatMap(p -> p.getServices().stream()).flatMap(s -> s.getResources().stream()).filter(ResourceSnapshot::isSet).map(r -> DtoMapper.toObservation(this.uriInfo, r)).collect(Collectors.toList());
        return list;
    }
}

