/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbound.security.oidc;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.sensinact.northbound.security.api.UserInfo;

public class JwsUserInfo
implements UserInfo {
    private final String subject;
    private final Set<String> groups;

    public JwsUserInfo(Jws<Claims> jws, Function<Jws<Claims>, Set<String>> groupMapper) {
        this.subject = ((Claims)jws.getBody()).getSubject();
        this.groups = groupMapper.apply(jws);
    }

    public String getUserId() {
        return this.subject;
    }

    public boolean isMemberOfGroup(String group) {
        return this.groups.contains(group);
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isAuthenticated() {
        return true;
    }
}

