/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbound.security.oidc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtHandler;
import io.jsonwebtoken.JwtHandlerAdapter;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.sensinact.gateway.northbound.security.oidc.Certificates;
import org.eclipse.sensinact.gateway.northbound.security.oidc.JwsUserInfo;
import org.eclipse.sensinact.gateway.northbound.security.oidc.KeyResolver;
import org.eclipse.sensinact.northbound.security.api.Authenticator;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"sensinact.northbound.auth.oidc"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class OIDCTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(OIDCTokenValidator.class);
    private final ObjectMapper mapper = JsonMapper.builder().build();
    private boolean running = true;
    private BundleContext ctx;
    private AuthenticationServiceConfig configuration;
    private HttpClient client;
    private List<Certificates.KeyInfo> keys;
    private ServiceRegistration<Authenticator> reg;
    private final Object lock = new Object();

    @Activate
    void activate(BundleContext ctx, AuthenticationServiceConfig configuration) throws Exception {
        this.configuration = configuration;
        this.ctx = ctx;
        String discovery = configuration.discoveryURL();
        if (discovery == null || discovery.isBlank()) {
            throw new IllegalArgumentException("The OpenId Connect discovery URL is not set.");
        }
        LOG.info("Starting OIDC validation for {}", (Object)discovery);
        this.client = this.getClient();
        this.client.getExecutor().execute(this::checkAndUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void stop() {
        ServiceRegistration<Authenticator> toUnregister;
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            toUnregister = this.reg;
            this.reg = null;
        }
        this.safeUnregister(toUnregister);
        try {
            this.client.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HttpClient getClient() throws Exception {
        String truststore;
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(this.configuration.ignore_ssl_errors());
        String keystore = this.configuration.keystore();
        if (!keystore.isBlank()) {
            sslContextFactory.setKeyStorePath(keystore);
            String keystorePw = this.configuration._keystore_password();
            if (!keystorePw.isBlank()) {
                sslContextFactory.setKeyStorePassword(keystorePw);
            }
        }
        if (!(truststore = this.configuration.truststore()).isBlank()) {
            sslContextFactory.setTrustStorePath(truststore);
            String truststorePw = this.configuration._truststore_password();
            if (!truststorePw.isBlank()) {
                sslContextFactory.setTrustStorePassword(truststorePw);
            }
        }
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        clientConnector.setConnectTimeout(Duration.ofSeconds(5L));
        HttpClient client = new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
        client.start();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdate() {
        boolean reschedule;
        ServiceRegistration toUnregister;
        List<Certificates.KeyInfo> loadKeys = this.loadKeys();
        if (loadKeys == null) {
            Object object = this.lock;
            synchronized (object) {
                this.keys = null;
                toUnregister = this.reg;
                this.reg = null;
                reschedule = this.running;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (!loadKeys.equals(this.keys)) {
                this.keys = loadKeys;
                toUnregister = this.reg;
                this.reg = null;
            }
        }
        JwtParser parser = Jwts.parserBuilder().deserializeJsonWith((Deserializer)new JacksonDeserializer(this.mapper)).setSigningKeyResolver((SigningKeyResolver)new KeyResolver(loadKeys)).build();
        ServiceRegistration registration = this.ctx.registerService(Authenticator.class, (Object)new Validator(this.configuration.realm(), parser), null);
        Object object2 = this.lock;
        synchronized (object2) {
            if (loadKeys.equals(this.keys) && this.reg == null && this.running) {
                this.reg = registration;
                toUnregister = null;
            } else {
                toUnregister = registration;
            }
            reschedule = this.running;
        }
        this.safeUnregister(toUnregister);
        if (reschedule) {
            this.client.getScheduler().schedule(this::checkAndUpdate, (long)this.configuration.tokenRefresh(), TimeUnit.SECONDS);
        }
    }

    private void safeUnregister(ServiceRegistration<?> reg) {
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private List<Certificates.KeyInfo> loadKeys() {
        try {
            InputStreamResponseListener listener = new InputStreamResponseListener();
            this.client.newRequest(this.configuration.discoveryURL()).accept(new String[]{"application/json"}).send((Response.CompleteListener)listener);
            JsonNode discovered = this.mapper.readTree(listener.getInputStream());
            String certs = discovered.get("jwks_uri").textValue();
            if (certs == null || certs.isBlank()) {
                LOG.warn("No URI available to query public keys");
                return null;
            }
            listener = new InputStreamResponseListener();
            this.client.newRequest(certs).accept(new String[]{"application/json"}).send((Response.CompleteListener)listener);
            return ((Certificates)this.mapper.readValue(listener.getInputStream(), Certificates.class)).getKeys();
        }
        catch (Exception e) {
            LOG.error("An error occurred while loading the validation keys", (Throwable)e);
            return null;
        }
    }

    public static @interface AuthenticationServiceConfig {
        public String discoveryURL();

        public boolean ignore_ssl_errors() default false;

        public String keystore() default "";

        public String _keystore_password() default "";

        public String truststore() default "";

        public String _truststore_password() default "";

        public int tokenRefresh() default 600;

        public int gracePeriod() default 300;

        public String realm();
    }

    private static class Validator
    implements Authenticator {
        private final JwtParser parser;
        private final String realm;

        public Validator(String realm, JwtParser parser) {
            this.realm = realm;
            this.parser = parser;
        }

        public UserInfo authenticate(String user, String credential) {
            return (UserInfo)this.parser.parse(credential, (JwtHandler)new JwtHandlerAdapter<UserInfo>(){

                public UserInfo onClaimsJws(Jws<Claims> jws) {
                    return new JwsUserInfo(jws, j -> Set.of());
                }
            });
        }

        public String getRealm() {
            return this.realm;
        }

        public Authenticator.Scheme getScheme() {
            return Authenticator.Scheme.TOKEN;
        }
    }
}

