/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.antlr.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.LdapFilterParser;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.LdapFilterParserBaseVisitor;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.Constants;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.IStringValue;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.PureString;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.RegexString;

public class ValueVisitor
extends LdapFilterParserBaseVisitor<Object> {
    @Override
    public Object visitAlpha(LdapFilterParser.AlphaContext ctx) {
        return ctx.getText();
    }

    @Override
    public String visitEscaped_hex(LdapFilterParser.Escaped_hexContext ctx) {
        return String.valueOf((char)Integer.parseInt(ctx.getText().substring(1), 16));
    }

    @Override
    public String visitEscaped_quote(LdapFilterParser.Escaped_quoteContext ctx) {
        return "\"";
    }

    private IStringValue stringFromParseTree(ParseTree tree) {
        Object result = this.visit(tree);
        if (result == null) {
            return new PureString(tree.getText());
        }
        if (result instanceof IStringValue) {
            return (IStringValue)result;
        }
        return new PureString(String.valueOf(result));
    }

    @Override
    public String visitPureString(LdapFilterParser.PureStringContext ctx) {
        StringBuilder builder = new StringBuilder();
        int nbChildren = ctx.getChildCount();
        for (int i = 0; i < nbChildren; ++i) {
            ParseTree child = ctx.getChild(i);
            builder.append(this.stringFromParseTree(child).getString());
        }
        return builder.toString();
    }

    @Override
    public String visitQuotedString(LdapFilterParser.QuotedStringContext ctx) {
        StringBuilder builder = new StringBuilder();
        int nbChildren = ctx.getChildCount();
        for (int i = 1; i < nbChildren - 1; ++i) {
            ParseTree child = ctx.getChild(i);
            builder.append(this.stringFromParseTree(child).getString());
        }
        return builder.toString();
    }

    @Override
    public Number visitNumericValue(LdapFilterParser.NumericValueContext ctx) {
        String strValue = ctx.getText();
        if (strValue.contains(".")) {
            return Double.parseDouble(strValue);
        }
        return Integer.parseInt(strValue);
    }

    @Override
    public Boolean visitBooleanValue(LdapFilterParser.BooleanValueContext ctx) {
        return Boolean.valueOf(ctx.getText().toLowerCase());
    }

    @Override
    public Object visitNullValue(LdapFilterParser.NullValueContext ctx) {
        return null;
    }

    @Override
    public Constants visitAnyValue(LdapFilterParser.AnyValueContext ctx) {
        return Constants.ANY;
    }

    @Override
    public IStringValue visitRegexString(LdapFilterParser.RegexStringContext ctx) {
        String pureString = ctx.pureString() != null ? this.visitPureString(ctx.pureString()) : null;
        List<LdapFilterParser.RegexStringContext> regexStrings = ctx.regexString();
        if (regexStrings.isEmpty()) {
            if (!ctx.STAR().isEmpty()) {
                return new RegexString(Pattern.compile(Pattern.quote(pureString) + ".*"));
            }
            return new PureString(pureString);
        }
        ArrayList<String> patterns = new ArrayList<String>(regexStrings.size() + 1);
        if (pureString != null) {
            patterns.add(Pattern.quote(pureString));
        } else {
            patterns.add("");
        }
        for (LdapFilterParser.RegexStringContext subContext : regexStrings) {
            IStringValue subValue = this.visitRegexString(subContext);
            if (subValue.isRegex()) {
                patterns.add(subValue.getPattern());
                continue;
            }
            patterns.add(subValue.getString());
        }
        return new RegexString(String.join((CharSequence)".*", patterns));
    }
}

