/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.ldap.impl;

import java.util.Map;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.northbound.filters.api.FilterParserException;
import org.eclipse.sensinact.northbound.filters.api.IFilterParser;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.LdapFilterLexer;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.LdapFilterParser;
import org.eclipse.sensinact.northbound.filters.ldap.antlr.impl.FilterVisitor;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IFilterParser.class}, property={"sensinact.filters.supported=ldap"})
public class LdapFilterComponent
implements IFilterParser {
    public ICriterion parseFilter(String query, String queryLanguage, Map<String, Object> parameters) throws FilterParserException {
        try {
            CodePointCharStream inStream = CharStreams.fromString((String)query);
            LdapFilterLexer markupLexer = new LdapFilterLexer((CharStream)inStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)markupLexer);
            LdapFilterParser parser = new LdapFilterParser((TokenStream)commonTokenStream);
            LdapFilterParser.FilterContext parsedContext = parser.filter();
            FilterVisitor visitor = new FilterVisitor(parser);
            return (ICriterion)visitor.visit((ParseTree)parsedContext);
        }
        catch (Exception e) {
            throw new FilterParserException("Error parsing LDAP query '" + query + "': " + e, (Throwable)e);
        }
    }
}

