/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.model.core.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public enum ResourceType implements Enumerator
{
    ACTION(0, "ACTION", "ACTION"),
    PROPERTY(1, "PROPERTY", "PROPERTY"),
    SENSOR(2, "SENSOR", "SENSOR"),
    STATE_VARIABLE(3, "STATE_VARIABLE", "STATE_VARIABLE");

    public static final int ACTION_VALUE = 0;
    public static final int PROPERTY_VALUE = 1;
    public static final int SENSOR_VALUE = 2;
    public static final int STATE_VARIABLE_VALUE = 3;
    private static final ResourceType[] VALUES_ARRAY;
    public static final List<ResourceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ResourceType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResourceType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ResourceType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResourceType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ResourceType get(int value) {
        switch (value) {
            case 0: {
                return ACTION;
            }
            case 1: {
                return PROPERTY;
            }
            case 2: {
                return SENSOR;
            }
            case 3: {
                return STATE_VARIABLE;
            }
        }
        return null;
    }

    private ResourceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ResourceType[]{ACTION, PROPERTY, SENSOR, STATE_VARIABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

