/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.virtual.temperature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.sensinact.core.push.DataUpdate;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.southbound.virtual.temperature.VirtualTemperatureSensor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"sensinact.virtual.temperature"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class VirtualTemperatureSensorComponent {
    @Reference
    DataUpdate push;
    private Random random = new Random();
    private final List<VirtualTemperatureSensor> sensors = new ArrayList<VirtualTemperatureSensor>();

    @Activate
    void start(Config config) throws Exception {
        String namePrefix = config.name();
        int i = 0;
        while ((long)i < config.sensor_count()) {
            Point point = new Point();
            point.coordinates = new Coordinates();
            point.coordinates.latitude = config.latitude();
            point.coordinates.longitude = config.longitude();
            double deltaRange = (double)i * 0.001;
            int latRange = i % 11 - 5;
            int lngRange = (i + 5) % 11 - 5;
            point.coordinates.latitude += deltaRange * (double)latRange;
            point.coordinates.longitude += deltaRange * (double)lngRange;
            String name = config.sensor_count() == 1L ? namePrefix : String.format("%s_%d", namePrefix, i);
            this.sensors.add(new VirtualTemperatureSensor(this.push, name, this.random, config.interval(), config.min(), config.max(), (GeoJsonObject)point));
            ++i;
        }
    }

    @Deactivate
    void stop() {
        this.sensors.forEach(VirtualTemperatureSensor::stop);
    }

    public static @interface Config {
        public long interval() default 30000L;

        public double min() default 0.0;

        public double max() default 30.0;

        public double latitude();

        public double longitude();

        public String name();

        public long sensor_count() default 1L;
    }
}

