/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.geojson.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.IOException;
import org.eclipse.sensinact.gateway.geojson.Coordinates;

public class CoordinatesDeserializer
extends StdNodeBasedDeserializer<Coordinates> {
    public CoordinatesDeserializer() {
        super(Coordinates.class);
    }

    public Coordinates convert(JsonNode root, DeserializationContext ctxt) throws IOException {
        if (root.isArray() && root.size() >= 2) {
            Coordinates c = new Coordinates();
            c.longitude = root.get(0).asDouble();
            c.latitude = root.get(1).asDouble();
            c.elevation = root.size() >= 3 ? root.get(2).asDouble() : Double.NaN;
            return c;
        }
        throw MismatchedInputException.from((JsonParser)ctxt.getParser(), Coordinates.class, (String)"GeoJSON coordinates must always be a list of at least two elements");
    }
}

