/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;

public class AnyMatch {
    public final List<Object> entries;
    public final BiFunction<Object, Object, Boolean> equalityPredicate;

    public AnyMatch(Collection<Object> entries) {
        this(entries, Objects::equals);
    }

    public AnyMatch(Collection<Object> entries, BiFunction<Object, Object, Boolean> predicate) {
        this.entries = new ArrayList<Object>(entries);
        this.equalityPredicate = predicate;
    }

    public boolean equals(Object other) {
        return this.entries.stream().anyMatch(e -> this.equalityPredicate.apply(e, other));
    }

    private boolean compare(Object other, Predicate<Integer> checker) {
        Instant otherInstant;
        if (other instanceof Number) {
            double otherDouble = ((Number)other).doubleValue();
            for (Object entry : this.entries) {
                Double entryDouble;
                if (!(entry instanceof Number) || !checker.test((entryDouble = Double.valueOf(((Number)entry).doubleValue())).compareTo(otherDouble))) continue;
                return true;
            }
            return false;
        }
        if (other instanceof Temporal && (otherInstant = this.toInstant(other)) != null) {
            for (Object entry : this.entries) {
                Instant entryInstant = this.toInstant(entry);
                if (entryInstant == null || !checker.test(entryInstant.compareTo(otherInstant))) continue;
                return true;
            }
            return false;
        }
        return this.compareComparable(other, checker);
    }

    private boolean compareComparable(Object other, Predicate<Integer> checker) {
        for (Object entry : this.entries) {
            Comparable entryCmp;
            if (!(entry instanceof Comparable) || !checker.test((entryCmp = (Comparable)entry).compareTo(other))) continue;
            return true;
        }
        return false;
    }

    private Instant toInstant(Object object) {
        if (object instanceof Instant) {
            return (Instant)object;
        }
        if (object instanceof OffsetDateTime) {
            return ((OffsetDateTime)object).toInstant();
        }
        return null;
    }

    public boolean lessThan(Object other) {
        if (other == null) {
            return false;
        }
        return this.compare(other, c -> c < 0);
    }

    public boolean lessEqual(Object other) {
        if (other == null) {
            return false;
        }
        return this.compare(other, c -> c <= 0);
    }

    public boolean greaterThan(Object other) {
        if (other == null) {
            return false;
        }
        return this.compare(other, c -> c > 0);
    }

    public boolean greaterEqual(Object other) {
        if (other == null) {
            return false;
        }
        return this.compare(other, c -> c >= 0);
    }

    public boolean compare(Object other, int comparatorRuleIndex) {
        return this.compare(other, comparatorRuleIndex, false);
    }

    public boolean compare(Object otherValue, int comparatorRuleIndex, boolean reversed) {
        Predicate<Object> comparator;
        switch (comparatorRuleIndex) {
            case 95: {
                comparator = this::equals;
                break;
            }
            case 96: {
                comparator = x -> !this.equals(x);
                break;
            }
            case 97: {
                if (!reversed) {
                    comparator = this::lessThan;
                    break;
                }
                comparator = this::greaterEqual;
                break;
            }
            case 98: {
                if (!reversed) {
                    comparator = this::lessEqual;
                    break;
                }
                comparator = this::greaterEqual;
                break;
            }
            case 99: {
                if (!reversed) {
                    comparator = this::greaterThan;
                    break;
                }
                comparator = this::lessEqual;
                break;
            }
            case 100: {
                if (!reversed) {
                    comparator = this::greaterEqual;
                    break;
                }
                comparator = this::lessEqual;
                break;
            }
            case 101: {
                throw new UnsupportedRuleException("HAS not yet implemented");
            }
            default: {
                throw new UnsupportedRuleException("Unexpected comparison rule: " + comparatorRuleIndex);
            }
        }
        return comparator.test(otherValue);
    }
}

