/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl;

import java.time.OffsetDateTime;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterBaseVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.AnyMatch;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.BooleanMethodCallExprVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.CommonExprVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.InvalidResultTypeException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ResourceValueFilterInputHolder;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;

public class BoolCommonExprVisitor
extends ODataFilterBaseVisitor<Predicate<ResourceValueFilterInputHolder>> {
    private static final double ESPILON = Math.pow(10.0, -6.0);
    final Parser parser;

    public BoolCommonExprVisitor(Parser parser) {
        this.parser = parser;
    }

    @Override
    public Predicate<ResourceValueFilterInputHolder> visitBoolmethodcallexpr(ODataFilterParser.BoolmethodcallexprContext ctx) {
        return ((Function)new BooleanMethodCallExprVisitor(this.parser).visitBoolmethodcallexpr(ctx))::apply;
    }

    @Override
    public Predicate<ResourceValueFilterInputHolder> visitIsofexpr(ODataFilterParser.IsofexprContext ctx) {
        return (Predicate)super.visitIsofexpr(ctx);
    }

    @Override
    public Predicate<ResourceValueFilterInputHolder> visitBoolcommonexpr(ODataFilterParser.BoolcommonexprContext ctx) {
        ParserRuleContext firstElement = (ParserRuleContext)ctx.getChild(ParserRuleContext.class, 0);
        int nbChildren = ctx.getChildCount();
        Predicate<ResourceValueFilterInputHolder> predicate = null;
        switch (firstElement.getRuleIndex()) {
            case 109: {
                predicate = this.visitIsofexpr(ctx.isofexpr());
                break;
            }
            case 51: {
                predicate = this.visitBoolmethodcallexpr(ctx.boolmethodcallexpr());
                break;
            }
            case 108: {
                predicate = Predicate.not(this.visitBoolcommonexpr(ctx.notexpr().boolcommonexpr()));
                break;
            }
            case 29: {
                Object leftExpr = new CommonExprVisitor(this.parser).visitCommonexpr((ODataFilterParser.CommonexprContext)firstElement);
                if (leftExpr == null) {
                    throw new RuntimeException("Unsupported left common expression: " + ((ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0)).toStringTree(this.parser));
                }
                if (nbChildren >= 2) {
                    BiFunction<Object, Object, Boolean> subPredicate;
                    Function rightExpr;
                    ParserRuleContext secondElement = (ParserRuleContext)ctx.getChild(ParserRuleContext.class, 1);
                    CommonExprVisitor rightVisitor = new CommonExprVisitor(this.parser);
                    int comparatorRuleIndex = secondElement.getRuleIndex();
                    switch (comparatorRuleIndex) {
                        case 95: {
                            rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.EqexprContext)secondElement).commonexpr());
                            subPredicate = this::exprEqual;
                            break;
                        }
                        case 96: {
                            rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.NeexprContext)secondElement).commonexpr());
                            subPredicate = this::exprNotEqual;
                            break;
                        }
                        case 97: {
                            rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.LtexprContext)secondElement).commonexpr());
                            subPredicate = (l, r) -> l != null && ((Comparable)l).compareTo(r) < 0;
                            break;
                        }
                        case 98: {
                            rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.LeexprContext)secondElement).commonexpr());
                            subPredicate = (l, r) -> l != null && ((Comparable)l).compareTo(r) <= 0;
                            break;
                        }
                        case 99: {
                            rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.GtexprContext)secondElement).commonexpr());
                            subPredicate = (l, r) -> l != null && ((Comparable)l).compareTo(r) > 0;
                            break;
                        }
                        case 100: {
                            rightExpr = (Function)rightVisitor.visit((ParseTree)((ODataFilterParser.GeexprContext)secondElement).commonexpr());
                            subPredicate = (l, r) -> l != null && ((Comparable)l).compareTo(r) >= 0;
                            break;
                        }
                        case 101: {
                            throw new UnsupportedRuleException("HAS not yet implemented");
                        }
                        default: {
                            subPredicate = null;
                            rightExpr = null;
                        }
                    }
                    if (rightExpr != null && subPredicate != null) {
                        predicate = arg_0 -> BoolCommonExprVisitor.lambda$visitBoolcommonexpr$4((Function)leftExpr, rightExpr, comparatorRuleIndex, subPredicate, arg_0);
                    }
                }
                if (predicate != null) break;
                predicate = arg_0 -> BoolCommonExprVisitor.lambda$visitBoolcommonexpr$5((Function)leftExpr, arg_0);
                break;
            }
            case 91: {
                predicate = this.visitBoolcommonexpr(ctx.boolparenexpr().boolcommonexpr());
                break;
            }
            default: {
                System.err.println("Unknown boolean common expression: " + firstElement.getRuleIndex());
                return null;
            }
        }
        if (nbChildren > 1) {
            ParserRuleContext lastElement = (ParserRuleContext)ctx.getChild(ParserRuleContext.class, nbChildren - 1);
            switch (lastElement.getRuleIndex()) {
                case 93: {
                    if (predicate == null) {
                        throw new InvalidResultTypeException("AND requires a boolean expression on both sides");
                    }
                    ODataFilterParser.AndexprContext and = (ODataFilterParser.AndexprContext)lastElement;
                    Object other = this.visitBoolcommonexpr(and.boolcommonexpr());
                    return predicate.and((Predicate<ResourceValueFilterInputHolder>)other);
                }
                case 94: {
                    if (predicate == null) {
                        System.err.println("AND requires a boolean expression on left side");
                        return null;
                    }
                    ODataFilterParser.OrexprContext or = (ODataFilterParser.OrexprContext)lastElement;
                    Object other = this.visitBoolcommonexpr(or.boolcommonexpr());
                    return predicate.or((Predicate<ResourceValueFilterInputHolder>)other);
                }
            }
        }
        return predicate;
    }

    private boolean exprEqual(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left instanceof Number && right instanceof Number) {
            return Math.abs(((Number)left).doubleValue() - ((Number)right).doubleValue()) <= ESPILON;
        }
        if (left instanceof Comparable) {
            return ((Comparable)left).compareTo(right) == 0;
        }
        return left.equals(right);
    }

    private boolean exprNotEqual(Object left, Object right) {
        if (left == null) {
            return right != null;
        }
        if (right == null) {
            return true;
        }
        if (left instanceof Number && right instanceof Number) {
            return Math.abs(((Number)left).doubleValue() - ((Number)right).doubleValue()) > ESPILON;
        }
        if (left instanceof Comparable) {
            return ((Comparable)left).compareTo(right) != 0;
        }
        return !left.equals(right);
    }

    private static /* synthetic */ boolean lambda$visitBoolcommonexpr$5(Function leftExpr, ResourceValueFilterInputHolder x) {
        Object result = leftExpr.apply(x);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return result != null;
    }

    private static /* synthetic */ boolean lambda$visitBoolcommonexpr$4(Function leftExpr, Function rightExpr, int comparatorRuleIndex, BiFunction subPredicate, ResourceValueFilterInputHolder x) {
        Object leftValue = leftExpr.apply(x);
        Object rightValue = rightExpr.apply(x);
        if (leftValue instanceof AnyMatch) {
            return ((AnyMatch)leftValue).compare(rightValue, comparatorRuleIndex);
        }
        if (rightValue instanceof AnyMatch) {
            return ((AnyMatch)rightValue).compare(leftValue, comparatorRuleIndex, true);
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            if (leftValue instanceof Double || rightValue instanceof Double) {
                leftValue = ((Number)leftValue).doubleValue();
                rightValue = ((Number)rightValue).doubleValue();
            }
        } else {
            if (leftValue instanceof OffsetDateTime) {
                leftValue = ((OffsetDateTime)leftValue).toInstant();
            }
            if (rightValue instanceof OffsetDateTime) {
                rightValue = ((OffsetDateTime)rightValue).toInstant();
            }
        }
        try {
            return (Boolean)subPredicate.apply(leftValue, rightValue);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

