/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.DatastreamPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.PathUtils;

public class ObservedPropertyPathHandler {
    private final ProviderSnapshot provider;
    private final ResourceSnapshot resource;
    private final Map<String, Function<String, Object>> subPartHandlers = Map.of("datastreams", this::subDatastreams);

    public ObservedPropertyPathHandler(ProviderSnapshot provider, ResourceSnapshot resource) {
        this.provider = provider;
        this.resource = resource;
    }

    public Object handle(String path) {
        String[] parts = path.toLowerCase().split("/");
        if (parts.length == 1) {
            switch (parts[0]) {
                case "id": {
                    return String.join((CharSequence)"~", this.provider.getName(), this.resource.getService().getName(), this.resource.getName());
                }
            }
            return PathUtils.getResourceLevelField(this.provider, this.resource, parts[0]);
        }
        Function<String, Object> handler = this.subPartHandlers.get(parts[0]);
        if (handler == null) {
            throw new UnsupportedRuleException("Unsupported path: " + path);
        }
        return handler.apply(String.join((CharSequence)"/", Arrays.copyOfRange(parts, 1, parts.length)));
    }

    private Object subDatastreams(String path) {
        return new DatastreamPathHandler(this.provider, this.resource).handle(path);
    }
}

