/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths;

import java.util.List;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ResourceValueFilterInputHolder;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.DatastreamPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.FeatureOfInterestPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.HistoricalLocationPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.LocationPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.ObservationPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.ObservedPropertyPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.SensorPathHandler;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths.ThingPathHandler;

public class PathHandler {
    private final String path;

    public PathHandler(String path) {
        this.path = path;
    }

    public Object handle(ResourceValueFilterInputHolder holder) {
        ProviderSnapshot provider = holder.getProvider();
        List<ResourceSnapshot> resources = holder.getResources();
        ResourceSnapshot resource = holder.getResource();
        switch (holder.getContext()) {
            case THINGS: {
                return new ThingPathHandler(provider, resources).handle(this.path);
            }
            case FEATURES_OF_INTEREST: {
                return new FeatureOfInterestPathHandler(provider, resources).handle(this.path);
            }
            case HISTORICAL_LOCATIONS: {
                return new HistoricalLocationPathHandler(provider, resources).handle(this.path);
            }
            case LOCATIONS: {
                return new LocationPathHandler(provider, resources).handle(this.path);
            }
            case OBSERVATIONS: {
                return new ObservationPathHandler(provider, resource).handle(this.path);
            }
            case DATASTREAMS: {
                return new DatastreamPathHandler(provider, resource).handle(this.path);
            }
            case OBSERVED_PROPERTIES: {
                return new ObservedPropertyPathHandler(provider, resource).handle(this.path);
            }
            case SENSORS: {
                return new SensorPathHandler(provider, resource).handle(this.path);
            }
        }
        throw new UnsupportedRuleException("Path of " + holder.getContext() + " is not yet supported");
    }
}

