/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.paths;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;

public class PathUtils {
    public static String timestampToString(Instant timestamp) {
        return Long.toString(timestamp.toEpochMilli(), 16);
    }

    public static ResourceSnapshot findResource(ProviderSnapshot provider, String service, String resource) {
        for (ServiceSnapshot svc : provider.getServices()) {
            if (!svc.getName().equals(service)) continue;
            for (ResourceSnapshot rc : svc.getResources()) {
                if (!rc.getName().equals(resource)) continue;
                return rc;
            }
        }
        return null;
    }

    public static Optional<Object> getResourceValue(ProviderSnapshot provider, String service, String resource) {
        ResourceSnapshot rc = PathUtils.findResource(provider, service, resource);
        if (rc != null && rc.getValue() != null) {
            return Optional.ofNullable(rc.getValue().getValue());
        }
        return Optional.empty();
    }

    public static Object getResourceLevelField(ProviderSnapshot provider, ResourceSnapshot resource, String path) {
        TimedValue rcValue = resource.getValue();
        switch (path) {
            case "result": {
                if (rcValue != null) {
                    return rcValue.getValue();
                }
                return null;
            }
            case "resulttime": 
            case "phenomenontime": 
            case "validtime": {
                if (rcValue != null) {
                    return rcValue.getTimestamp();
                }
                return null;
            }
            case "resultquality": {
                return null;
            }
            case "observedarea": {
                return PathUtils.getResourceValue(provider, "admin", "location").orElse(null);
            }
            case "properties": {
                return Map.of();
            }
        }
        throw new UnsupportedRuleException("Unexpected resource level field: " + path);
    }

    public static Object getProviderLevelField(ProviderSnapshot provider, List<ResourceSnapshot> resources, String path) {
        switch (path) {
            case "name": {
                return PathUtils.getResourceValue(provider, "admin", "friendlyName").orElse(provider.getName());
            }
            case "description": {
                return PathUtils.getResourceValue(provider, "admin", "description").orElse(provider.getName());
            }
            case "location": {
                return PathUtils.getResourceValue(provider, "admin", "location").orElse(null);
            }
        }
        Optional<Object> value = PathUtils.getResourceValue(provider, "admin", path);
        if (value.isPresent()) {
            return value.get();
        }
        throw new UnsupportedRuleException("Unexpected provider level field: " + path);
    }
}

