/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.impl;

import java.util.Map;
import java.util.function.Predicate;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.northbound.filters.api.FilterParserException;
import org.eclipse.sensinact.northbound.filters.api.IFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.EFilterContext;
import org.eclipse.sensinact.northbound.filters.sensorthings.ISensorthingsFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterLexer;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.BoolCommonExprVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.impl.SensorthingsCriterion;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IFilterParser.class, ISensorthingsFilterParser.class}, property={"sensinact.filters.supported={ogc,sensorthings}"})
public class SensorthingsFilterComponent
implements IFilterParser,
ISensorthingsFilterParser {
    public ICriterion parseFilter(String query, String queryLanguage, Map<String, Object> parameters) throws FilterParserException {
        EFilterContext context = null;
        Object rawContext = parameters.get("context");
        if (rawContext instanceof EFilterContext) {
            context = (EFilterContext)((Object)rawContext);
        } else if (rawContext instanceof String) {
            context = EFilterContext.valueOf((String)rawContext);
        }
        if (context == null) {
            throw new FilterParserException("Can't parse a SensorThings filter without a context");
        }
        return this.parseFilter(query, context);
    }

    @Override
    public ICriterion parseFilter(String query, EFilterContext filterContext) throws FilterParserException {
        Predicate predicate;
        try {
            ANTLRInputStream inStream = new ANTLRInputStream(query);
            ODataFilterLexer markupLexer = new ODataFilterLexer((CharStream)inStream);
            CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)markupLexer);
            ODataFilterParser parser = new ODataFilterParser((TokenStream)commonTokenStream);
            ODataFilterParser.BoolcommonexprContext parsedContext = parser.boolcommonexpr();
            BoolCommonExprVisitor visitor = new BoolCommonExprVisitor(parser);
            predicate = (Predicate)visitor.visit((ParseTree)parsedContext);
        }
        catch (Exception e) {
            throw new FilterParserException("Error parsing SensorThings query '" + query + "': " + e, (Throwable)e);
        }
        return new SensorthingsCriterion(filterContext, predicate);
    }
}

