/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.nortbound.session.impl;

import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.command.GetLevel;
import org.eclipse.sensinact.core.command.ResourceCommand;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.notification.ClientActionListener;
import org.eclipse.sensinact.core.notification.ClientDataListener;
import org.eclipse.sensinact.core.notification.ClientLifecycleListener;
import org.eclipse.sensinact.core.notification.ClientMetadataListener;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceActionNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.core.snapshot.ICriterion;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.northbound.security.api.AuthorizationEngine;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.ProviderDescription;
import org.eclipse.sensinact.northbound.session.ResourceDescription;
import org.eclipse.sensinact.northbound.session.ResourceShortDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.ServiceDescription;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensiNactSessionImpl
implements SensiNactSession {
    private static final Logger LOG = LoggerFactory.getLogger(SensiNactSessionImpl.class);
    private final Object lock = new Object();
    private final String sessionId = UUID.randomUUID().toString();
    private final Map<String, List<String>> listenerRegistrations = new HashMap<String, List<String>>();
    private final NavigableMap<String, List<SessionListenerRegistration>> listenersByWildcardTopic = new TreeMap<String, List<SessionListenerRegistration>>();
    private final Map<String, List<SessionListenerRegistration>> listenersByTopic = new HashMap<String, List<SessionListenerRegistration>>();
    private Instant expiry;
    private boolean expired;
    private final GatewayThread thread;
    private final UserInfo user;
    private final AuthorizationEngine.Authorizer authorizer;

    public SensiNactSessionImpl(UserInfo user, AuthorizationEngine.Authorizer authorizer, GatewayThread thread) {
        this.user = user;
        this.authorizer = authorizer;
        this.thread = thread;
        this.expiry = Instant.now().plusSeconds(600L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> activeListeners() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<String, List<String>>(this.listenerRegistrations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addListener(List<String> topics, ClientDataListener cdl, ClientMetadataListener cml, ClientLifecycleListener cll, ClientActionListener cal) {
        String subscriptionId = UUID.randomUUID().toString();
        Object object = this.lock;
        synchronized (object) {
            if (cdl != null) {
                this.addListenerTopic(topics, "DATA/", new SessionDataListener(subscriptionId, this.authorizer, cdl));
            }
            if (cml != null) {
                this.addListenerTopic(topics, "METADATA/", new SessionMetadataListener(subscriptionId, this.authorizer, cml));
            }
            if (cll != null) {
                this.addListenerTopic(topics, "LIFECYCLE/", new SessionLifecycleListener(subscriptionId, this.authorizer, cll));
            }
            if (cal != null) {
                this.addListenerTopic(topics, "ACTION/", new SessionActionListener(subscriptionId, this.authorizer, cal));
            }
            this.listenerRegistrations.put(subscriptionId, List.copyOf(topics));
        }
        return subscriptionId;
    }

    private void addListenerTopic(List<String> topics, String prefix, SessionListenerRegistration reg) {
        topics.stream().map(prefix::concat).forEach(s -> {
            if (s.endsWith("*")) {
                this.listenersByWildcardTopic.merge(s.substring(0, s.length() - 1), List.of(reg), this::mergeLists);
            } else {
                this.listenersByTopic.merge((String)s, List.of(reg), this::mergeLists);
            }
        });
    }

    private List<SessionListenerRegistration> mergeLists(List<SessionListenerRegistration> a, List<SessionListenerRegistration> b) {
        return Stream.of(a, b).flatMap(Collection::stream).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String id) {
        Object object = this.lock;
        synchronized (object) {
            List<String> topics = this.listenerRegistrations.remove(id);
            if (topics != null) {
                this.removeListener(id, "DATA/", topics);
                this.removeListener(id, "METADATA/", topics);
                this.removeListener(id, "LIFECYCLE/", topics);
                this.removeListener(id, "ACTION/", topics);
            }
        }
    }

    private void removeListener(String subscriptionId, String prefix, List<String> topics) {
        topics.stream().map(prefix::concat).forEach(s -> {
            if (s.endsWith("*")) {
                this.listenersByWildcardTopic.computeIfPresent(s.substring(0, s.length() - 1), (topic, regs) -> this.removeSubscription(subscriptionId, (List<SessionListenerRegistration>)regs));
            } else {
                this.listenersByTopic.computeIfPresent((String)s, (topic, regs) -> this.removeSubscription(subscriptionId, (List<SessionListenerRegistration>)regs));
            }
        });
    }

    private List<SessionListenerRegistration> removeSubscription(String subscriptionId, List<SessionListenerRegistration> regs) {
        List<SessionListenerRegistration> list = regs.stream().filter(r -> !r.subscriptionId.equals(subscriptionId)).collect(Collectors.toList());
        return list.isEmpty() ? null : list;
    }

    private <I, T> T executeGetCommand(Function<SensinactDigitalTwin, I> caller, Function<I, T> converter) {
        return this.executeGetCommand(caller, converter, null);
    }

    private <I, T> T executeGetCommand(final Function<SensinactDigitalTwin, I> caller, final Function<I, T> converter, final T defaultValue) {
        return this.safeExecute(new AbstractTwinCommand<T>(){

            protected Promise<T> call(SensinactDigitalTwin model, PromiseFactory pf) {
                try {
                    Object modelValue = caller.apply(model);
                    Object value = modelValue != null ? converter.apply(modelValue) : defaultValue;
                    return pf.resolved(value);
                }
                catch (Exception e) {
                    return pf.failed((Throwable)e);
                }
            }
        });
    }

    private <T> T safeExecute(AbstractTwinCommand<T> command) {
        return this.safeGetValue(this.thread.execute(command));
    }

    private <T> T safeGetValue(Promise<T> promise) {
        try {
            Throwable t = promise.getFailure();
            if (t != null) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            return (T)promise.getValue();
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getResourceValue(String provider, String service, String resource, Class<T> clazz) {
        TimedValue<T> tv = this.getResourceTimedValue(provider, service, resource, clazz);
        if (tv != null) {
            return (T)tv.getValue();
        }
        return null;
    }

    public <T> T getResourceValue(String provider, String service, String resource, Class<T> clazz, GetLevel getLevel) {
        TimedValue<T> tv = this.getResourceTimedValue(provider, service, resource, clazz, getLevel);
        if (tv != null) {
            return (T)tv.getValue();
        }
        return null;
    }

    public <T> TimedValue<T> getResourceTimedValue(String provider, String service, String resource, Class<T> clazz) {
        return this.getResourceTimedValue(provider, service, resource, clazz, GetLevel.NORMAL);
    }

    public <T> TimedValue<T> getResourceTimedValue(String provider, String service, String resource, Class<T> clazz, GetLevel getLevel) {
        return this.doGetResourceTimedValue(provider, service, resource, clazz, getLevel);
    }

    private <T> TimedValue<T> doGetResourceTimedValue(String provider, String service, String resource, Class<T> clazz, GetLevel getLevel) {
        return (TimedValue)this.doResourceWork(provider, service, resource, sr -> sr.getValue(clazz, getLevel), AuthorizationEngine.PermissionLevel.READ, () -> String.format("The user %s does not have permission to read resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
    }

    public void setResourceValue(String provider, String service, String resource, Object o) {
        this.setResourceValue(provider, service, resource, o, Instant.now());
    }

    public void setResourceValue(String provider, String service, String resource, Object o, Instant instant) {
        this.doSetResourceValue(provider, service, resource, o, instant);
    }

    private void doSetResourceValue(String provider, String service, String resource, Object o, Instant instant) {
        this.doResourceWork(provider, service, resource, sr -> sr.setValue(o, instant), AuthorizationEngine.PermissionLevel.UPDATE, () -> String.format("The user %s does not have permission to set resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
    }

    private <T> T doResourceWork(final String provider, final String service, final String resource, final Function<SensinactResource, Promise<T>> work, final AuthorizationEngine.PermissionLevel permissionLevel, final Supplier<String> authFailureMessage) {
        final AuthorizationEngine.Authorizer.PreAuth preAuth = this.authorizer.preAuthResource(permissionLevel, provider, service, resource);
        if (preAuth == AuthorizationEngine.Authorizer.PreAuth.DENY) {
            throw new AuthorizationEngine.NotPermittedException(authFailureMessage.get());
        }
        return this.safeExecute(new AbstractTwinCommand<T>(){

            protected Promise<T> call(SensinactDigitalTwin model, PromiseFactory pf) {
                try {
                    SensinactProvider sp;
                    SensinactResource sensinactResource = model.getResource(provider, service, resource);
                    if (sensinactResource != null) {
                        SensinactProvider sp2;
                        if (preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && !SensiNactSessionImpl.this.authorizer.hasResourcePermission(permissionLevel, (sp2 = sensinactResource.getService().getProvider()).getModelPackageUri(), sp2.getModelName(), provider, service, resource)) {
                            return pf.failed((Throwable)new AuthorizationEngine.NotPermittedException((String)authFailureMessage.get()));
                        }
                        if (sensinactResource.getResourceType() == ResourceType.ACTION) {
                            return pf.resolved(null);
                        }
                        return (Promise)work.apply(sensinactResource);
                    }
                    if (preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && ((sp = model.getProvider(provider)) != null ? !SensiNactSessionImpl.this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, sp.getModelPackageUri(), sp.getModelName(), provider, service, resource) : !SensiNactSessionImpl.this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, null, null, provider, service, resource))) {
                        return pf.failed((Throwable)new AuthorizationEngine.NotPermittedException((String)authFailureMessage.get()));
                    }
                    return pf.resolved(null);
                }
                catch (Throwable t) {
                    return pf.failed(t);
                }
            }
        });
    }

    public Map<String, Object> getResourceMetadata(String provider, String service, String resource) {
        return Map.copyOf((Map)this.doResourceWork(provider, service, resource, SensinactResource::getMetadataValues, AuthorizationEngine.PermissionLevel.READ, () -> String.format("The user %s does not have permission to read metadata for resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource))));
    }

    public void setResourceMetadata(String provider, String service, String resource, Map<String, Object> metadata) {
        Instant timestamp = Instant.now();
        Function setMetadata = sr -> this.thread.getPromiseFactory().all((Collection)metadata.entrySet().stream().map(e -> sr.setMetadataValue((String)e.getKey(), e.getValue(), timestamp)).collect(Collectors.toList())).map(x -> null);
        this.doResourceWork(provider, service, resource, setMetadata, AuthorizationEngine.PermissionLevel.UPDATE, () -> String.format("The user %s does not have permission to set metadata for resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
    }

    public TimedValue<Object> getResourceMetadataValue(String provider, String service, String resource, String metadata) {
        return (TimedValue)this.doResourceWork(provider, service, resource, sr -> sr.getMetadataValue(metadata), AuthorizationEngine.PermissionLevel.READ, () -> String.format("The user %s does not have permission to read metadata for resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
    }

    public void setResourceMetadata(String provider, String service, String resource, final String metadata, final Object value) {
        final Instant timestamp = Instant.now();
        this.safeExecute((AbstractTwinCommand)new ResourceCommand<Void>(provider, service, resource){

            protected Promise<Void> call(SensinactResource resource, PromiseFactory pf) {
                return resource.setMetadataValue(metadata, value, timestamp);
            }
        });
    }

    public Object actOnResource(String provider, String service, String resource, final Map<String, Object> parameters) {
        return this.safeExecute((AbstractTwinCommand)new ResourceCommand<Object>(provider, service, resource){

            protected Promise<Object> call(SensinactResource resource, PromiseFactory pf) {
                try {
                    return resource.act(parameters);
                }
                catch (Throwable t) {
                    return pf.failed(t);
                }
            }
        });
    }

    public ResourceDescription describeResource(final String provider, final String service, final String resource) {
        final AuthorizationEngine.Authorizer.PreAuth preAuth = this.authorizer.preAuthResource(AuthorizationEngine.PermissionLevel.DESCRIBE, provider, service, resource);
        if (preAuth == AuthorizationEngine.Authorizer.PreAuth.DENY) {
            throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
        }
        return this.safeExecute(new AbstractTwinCommand<ResourceDescription>(){

            protected Promise<ResourceDescription> call(SensinactDigitalTwin model, PromiseFactory pf) {
                try {
                    SensinactProvider sp;
                    SensinactResource sensinactResource = model.getResource(provider, service, resource);
                    if (sensinactResource != null) {
                        Promise val;
                        SensinactProvider sp2;
                        if (preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && !SensiNactSessionImpl.this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, (sp2 = sensinactResource.getService().getProvider()).getModelPackageUri(), sp2.getModelName(), provider, service, resource)) {
                            throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe resource %s", SensiNactSessionImpl.this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
                        }
                        ResourceType resourceType = sensinactResource.getResourceType();
                        switch (resourceType) {
                            case ACTION: {
                                val = pf.resolved(null);
                                break;
                            }
                            default: {
                                val = sensinactResource.getValue(Object.class, GetLevel.NORMAL);
                            }
                        }
                        Promise metadata = sensinactResource.getMetadataValues();
                        return val.then(x -> metadata).then(x -> {
                            ResourceDescription result = new ResourceDescription();
                            result.provider = provider;
                            result.service = service;
                            result.resource = resource;
                            result.contentType = sensinactResource.getType();
                            result.resourceType = resourceType;
                            result.metadata = (Map)metadata.getValue();
                            switch (resourceType) {
                                case ACTION: {
                                    result.actMethodArgumentsTypes = sensinactResource.getArguments();
                                    break;
                                }
                                default: {
                                    result.valueType = ValueType.UPDATABLE;
                                    result.value = ((TimedValue)val.getValue()).getValue();
                                    result.timestamp = ((TimedValue)val.getValue()).getTimestamp();
                                }
                            }
                            return pf.resolved((Object)result);
                        });
                    }
                    if (preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && ((sp = model.getProvider(provider)) != null ? !SensiNactSessionImpl.this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, sp.getModelPackageUri(), sp.getModelName(), provider, service, resource) : !SensiNactSessionImpl.this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, null, null, provider, service, resource))) {
                        throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe resource %s", SensiNactSessionImpl.this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
                    }
                    return pf.resolved(null);
                }
                catch (Throwable t) {
                    return pf.failed(t);
                }
            }
        });
    }

    public ResourceShortDescription describeResourceShort(String provider, String service, String resource) {
        AuthorizationEngine.Authorizer.PreAuth preAuth = this.authorizer.preAuthResource(AuthorizationEngine.PermissionLevel.DESCRIBE, provider, service, resource);
        if (preAuth == AuthorizationEngine.Authorizer.PreAuth.DENY) {
            throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
        }
        return this.executeGetCommand(m -> {
            SensinactProvider sp;
            SensinactResource sr = m.getResource(provider, service, resource);
            if (sr != null ? preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && !this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, (sp = sr.getService().getProvider()).getModelPackageUri(), sp.getModelName(), provider, service, resource) : preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && ((sp = m.getProvider(provider)) != null ? !this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, sp.getModelPackageUri(), sp.getModelName(), provider, service, resource) : !this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, null, null, provider, service, resource))) {
                throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe resource %s", this.user.getUserId(), String.format("%s/%s/%s", provider, service, resource)));
            }
            return sr;
        }, rc -> {
            ResourceShortDescription result = new ResourceShortDescription();
            result.contentType = rc.getType();
            result.name = rc.getName();
            result.resourceType = rc.getResourceType();
            if (result.resourceType == ResourceType.ACTION) {
                result.actMethodArgumentsTypes = rc.getArguments();
            } else {
                result.valueType = ValueType.UPDATABLE;
            }
            return result;
        });
    }

    public ServiceDescription describeService(String provider, String service) {
        AuthorizationEngine.Authorizer.PreAuth preAuth = this.authorizer.preAuthService(AuthorizationEngine.PermissionLevel.DESCRIBE, provider, service);
        if (preAuth == AuthorizationEngine.Authorizer.PreAuth.DENY) {
            throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe service %s", this.user.getUserId(), String.format("%s/%s", provider, service)));
        }
        return this.executeGetCommand(m -> {
            SensinactProvider sp;
            SensinactService ss = m.getService(provider, service);
            if (ss != null ? preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && !this.authorizer.hasServicePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, (sp = ss.getProvider()).getModelPackageUri(), sp.getModelName(), provider, service) : preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && ((sp = m.getProvider(provider)) != null ? !this.authorizer.hasServicePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, sp.getModelPackageUri(), sp.getModelName(), provider, service) : !this.authorizer.hasServicePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, null, null, provider, service))) {
                throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe service %s", this.user.getUserId(), String.format("%s/%s", provider, service)));
            }
            return ss;
        }, snSvc -> {
            SensinactProvider sp = snSvc.getProvider();
            ServiceDescription description = new ServiceDescription();
            description.service = snSvc.getName();
            description.provider = snSvc.getProvider().getName();
            description.resources = List.copyOf(this.authorizer.visibleResources(sp.getModelPackageUri(), sp.getModelName(), provider, service, snSvc.getResources().keySet()));
            return description;
        });
    }

    public ProviderDescription describeProvider(String provider) {
        AuthorizationEngine.Authorizer.PreAuth preAuth = this.authorizer.preAuthProvider(AuthorizationEngine.PermissionLevel.DESCRIBE, provider);
        if (preAuth == AuthorizationEngine.Authorizer.PreAuth.DENY) {
            throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe service %s", this.user.getUserId(), String.format("%s", provider)));
        }
        return this.executeGetCommand(m -> {
            SensinactProvider sp = m.getProvider(provider);
            if (preAuth == AuthorizationEngine.Authorizer.PreAuth.UNKNOWN && (sp != null ? !this.authorizer.hasProviderPermission(AuthorizationEngine.PermissionLevel.DESCRIBE, sp.getModelPackageUri(), sp.getModelName(), provider) : !this.authorizer.hasProviderPermission(AuthorizationEngine.PermissionLevel.DESCRIBE, null, null, provider))) {
                throw new AuthorizationEngine.NotPermittedException(String.format("The user %s does not have permission to describe provider %s", this.user.getUserId(), String.format("%s", provider)));
            }
            return sp;
        }, snProvider -> {
            ProviderDescription description = new ProviderDescription();
            description.provider = snProvider.getName();
            description.services = List.copyOf(this.authorizer.visibleServices(snProvider.getModelPackageUri(), snProvider.getModelName(), provider, snProvider.getServices().keySet()));
            return description;
        });
    }

    public List<ProviderDescription> listProviders() {
        return this.executeGetCommand(m -> m.getProviders(), providers -> providers.stream().filter(snProvider -> this.authorizer.hasProviderPermission(AuthorizationEngine.PermissionLevel.DESCRIBE, snProvider.getModelPackageUri(), snProvider.getModelName(), snProvider.getName())).map(snProvider -> {
            ProviderDescription description = new ProviderDescription();
            description.provider = snProvider.getName();
            description.services = List.copyOf(this.authorizer.visibleServices(snProvider.getModelPackageUri(), snProvider.getModelName(), snProvider.getName(), snProvider.getServices().keySet()));
            return description;
        }).collect(Collectors.toList()), List.of());
    }

    public List<ProviderSnapshot> filteredSnapshot(ICriterion filter) {
        Predicate<ServiceSnapshot> service = this::authorizeService;
        Predicate<ResourceSnapshot> resource = this::authorizeResource;
        if (filter == null) {
            return (List)this.executeGetCommand(m -> m.filteredSnapshot(null, ps -> this.authorizeProvider((ProviderSnapshot)ps, false), service, resource), Function.identity());
        }
        Predicate location = filter.getLocationFilter();
        Predicate<ProviderSnapshot> provider = ps -> this.authorizeProvider((ProviderSnapshot)ps, location != null);
        Predicate pf = filter.getProviderFilter();
        Predicate sf = filter.getServiceFilter();
        Predicate rf = filter.getResourceFilter();
        return (List)this.executeGetCommand(m -> m.filteredSnapshot(location, pf == null ? provider : provider.and(pf), sf == null ? service : service.and(sf), rf == null ? resource : resource.and(rf)), Function.identity());
    }

    private boolean authorizeProvider(ProviderSnapshot ps, boolean useLocation) {
        if (useLocation && !this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.READ, ps.getModelPackageUri(), ps.getModelName(), ps.getName(), "admin", "location")) {
            return false;
        }
        return this.authorizer.hasProviderPermission(AuthorizationEngine.PermissionLevel.DESCRIBE, ps.getModelPackageUri(), ps.getModelName(), ps.getName());
    }

    private boolean authorizeService(ServiceSnapshot ss) {
        ProviderSnapshot ps = ss.getProvider();
        return this.authorizer.hasServicePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, ps.getModelPackageUri(), ps.getModelName(), ps.getName(), ss.getName());
    }

    private boolean authorizeResource(ResourceSnapshot sr) {
        ServiceSnapshot ss = sr.getService();
        ProviderSnapshot ps = ss.getProvider();
        return this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, ps.getModelPackageUri(), ps.getModelName(), ps.getName(), ss.getName(), sr.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(String topic, AbstractResourceNotification event) {
        List toNotify;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isExpired()) {
                toNotify = new ArrayList();
                toNotify.addAll(this.listenersByTopic.getOrDefault(topic, List.of()));
                for (Map.Entry e : this.listenersByWildcardTopic.headMap(topic, true).descendingMap().entrySet()) {
                    if (!topic.startsWith((String)e.getKey())) break;
                    toNotify.addAll((Collection)e.getValue());
                }
            } else {
                toNotify = List.of();
            }
        }
        toNotify.forEach(s -> s.notify(topic, event));
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.expired && !this.expiry.isAfter(Instant.now())) {
                this.expired = true;
            }
            return this.expired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instant getExpiry() {
        Object object = this.lock;
        synchronized (object) {
            return this.isExpired() ? null : this.expiry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extend(Duration duration) {
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("The extension period must be greater than zero");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkWithException();
            this.expiry = Instant.now().plus(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Object object = this.lock;
        synchronized (object) {
            this.expired = true;
        }
    }

    private void checkWithException() {
        if (this.isExpired()) {
            throw new IllegalStateException("Session is expired");
        }
    }

    public UserInfo getUserInfo() {
        return this.user;
    }

    private static class SessionDataListener
    extends SessionListenerRegistration {
        private final ClientDataListener listener;

        public SessionDataListener(String subscriptionId, AuthorizationEngine.Authorizer authorizer, ClientDataListener listener) {
            super(subscriptionId, authorizer);
            this.listener = listener;
        }

        @Override
        public void notify(String topic, AbstractResourceNotification notification) {
            if (!this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.READ, notification.modelPackageUri, notification.model, notification.provider, notification.service, notification.resource)) {
                return;
            }
            this.listener.notify(topic, (ResourceDataNotification)notification);
        }
    }

    private static abstract class SessionListenerRegistration {
        private final String subscriptionId;
        protected final AuthorizationEngine.Authorizer authorizer;

        public SessionListenerRegistration(String subscriptionId, AuthorizationEngine.Authorizer authorizer) {
            this.subscriptionId = subscriptionId;
            this.authorizer = authorizer;
        }

        public abstract void notify(String var1, AbstractResourceNotification var2);
    }

    private static class SessionMetadataListener
    extends SessionListenerRegistration {
        private final ClientMetadataListener listener;

        public SessionMetadataListener(String subscriptionId, AuthorizationEngine.Authorizer authorizer, ClientMetadataListener listener) {
            super(subscriptionId, authorizer);
            this.listener = listener;
        }

        @Override
        public void notify(String topic, AbstractResourceNotification notification) {
            if (!this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.READ, notification.modelPackageUri, notification.model, notification.provider, notification.service, notification.resource)) {
                return;
            }
            this.listener.notify(topic, (ResourceMetaDataNotification)notification);
        }
    }

    private static class SessionLifecycleListener
    extends SessionListenerRegistration {
        private final ClientLifecycleListener listener;

        public SessionLifecycleListener(String subscriptionId, AuthorizationEngine.Authorizer authorizer, ClientLifecycleListener listener) {
            super(subscriptionId, authorizer);
            this.listener = listener;
        }

        @Override
        public void notify(String topic, AbstractResourceNotification notification) {
            LifecycleNotification ln = (LifecycleNotification)notification;
            switch (ln.status) {
                case PROVIDER_CREATED: 
                case PROVIDER_DELETED: {
                    if (this.authorizer.hasProviderPermission(AuthorizationEngine.PermissionLevel.DESCRIBE, ln.modelPackageUri, ln.model, ln.provider)) break;
                    return;
                }
                case RESOURCE_CREATED: 
                case RESOURCE_DELETED: {
                    if (this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, ln.modelPackageUri, ln.model, ln.provider, ln.service, ln.resource)) break;
                    return;
                }
                case SERVICE_CREATED: 
                case SERVICE_DELETED: {
                    if (this.authorizer.hasServicePermission(AuthorizationEngine.PermissionLevel.DESCRIBE, ln.modelPackageUri, ln.model, ln.provider, ln.service)) break;
                    return;
                }
                default: {
                    LOG.warn("Unrecognised lifecycle status {}. Denying access to the notification", (Object)ln.status);
                    return;
                }
            }
            this.listener.notify(topic, ln);
        }
    }

    private static class SessionActionListener
    extends SessionListenerRegistration {
        private final ClientActionListener listener;

        public SessionActionListener(String subscriptionId, AuthorizationEngine.Authorizer authorizer, ClientActionListener listener) {
            super(subscriptionId, authorizer);
            this.listener = listener;
        }

        @Override
        public void notify(String topic, AbstractResourceNotification notification) {
            if (!this.authorizer.hasResourcePermission(AuthorizationEngine.PermissionLevel.ACT, notification.modelPackageUri, notification.model, notification.provider, notification.service, notification.resource)) {
                return;
            }
            this.listener.notify(topic, (ResourceActionNotification)notification);
        }
    }
}

