/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.nortbound.session.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.metrics.IMetricsGauge;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.nortbound.session.impl.DefaultAuthPolicy;
import org.eclipse.sensinact.nortbound.session.impl.DefaultSessionAuthorizationEngine;
import org.eclipse.sensinact.nortbound.session.impl.SensiNactSessionImpl;
import org.eclipse.sensinact.northbound.security.api.AuthorizationEngine;
import org.eclipse.sensinact.northbound.security.api.UserInfo;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.northbound.session.SensiNactSessionManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.typedevent.TypedEventHandler;
import org.osgi.service.typedevent.propertytypes.EventTopics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"sensinact.session.manager"}, property={"sensinact.metrics.gauge.name=sensinact.sessions"})
@EventTopics(value={"LIFECYCLE/*", "METADATA/*", "DATA/*", "ACTION/*"})
public class SessionManager
implements SensiNactSessionManager,
TypedEventHandler<AbstractResourceNotification>,
IMetricsGauge {
    private static final Logger LOG = LoggerFactory.getLogger(SessionManager.class);
    @Reference
    GatewayThread thread;
    private final Object lock = new Object();
    private final Map<String, SensiNactSessionImpl> sessions = new HashMap<String, SensiNactSessionImpl>();
    private final Map<String, Set<String>> sessionsByUser = new HashMap<String, Set<String>>();
    private final Map<String, String> userDefaultSessionIds = new HashMap<String, String>();
    private AuthorizationEngine authEngine;
    private boolean active;
    private Config config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setAuthorization(AuthorizationEngine auth) {
        ArrayList<SensiNactSessionImpl> toInvalidate;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting an external Authorization Engine. Existing sessions will be invalidated");
        }
        Object object = this.lock;
        synchronized (object) {
            this.authEngine = auth;
            toInvalidate = new ArrayList<SensiNactSessionImpl>(this.sessions.values());
            this.sessions.clear();
            this.sessionsByUser.clear();
            this.userDefaultSessionIds.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} sessions will be invalidated", (Object)toInvalidate.size());
        }
        toInvalidate.forEach(SensiNactSession::expire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetAuthorization(AuthorizationEngine auth) {
        List toInvalidate;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing an external Authorization Engine. Existing sessions will be invalidated");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.authEngine == auth) {
                this.authEngine = null;
                toInvalidate = new ArrayList<SensiNactSessionImpl>(this.sessions.values());
                this.sessions.clear();
                this.sessionsByUser.clear();
                this.userDefaultSessionIds.clear();
            } else {
                toInvalidate = List.of();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} sessions will be invalidated", (Object)toInvalidate.size());
        }
        toInvalidate.forEach(SensiNactSession::expire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void start(Config config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting the Session Manager with session lifetime {} and default authorization policy {}", (Object)config.expiry(), (Object)config.auth_policy());
        }
        Object object = this.lock;
        synchronized (object) {
            this.active = true;
            this.config = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void stop() {
        ArrayList<SensiNactSessionImpl> toInvalidate;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down the session manager");
        }
        Object object = this.lock;
        synchronized (object) {
            this.active = false;
            toInvalidate = new ArrayList<SensiNactSessionImpl>(this.sessions.values());
            this.sessions.clear();
            this.sessionsByUser.clear();
            this.userDefaultSessionIds.clear();
        }
        toInvalidate.forEach(SensiNactSession::expire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object gauge() {
        Object object = this.lock;
        synchronized (object) {
            return this.sessions.size();
        }
    }

    private void doCheck() {
        if (!this.active) {
            throw new IllegalStateException("The session manager is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensiNactSession getDefaultSession(UserInfo user) {
        String sessionId;
        Objects.requireNonNull(user);
        SensiNactSession session = null;
        String userId = user.getUserId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting the default session for user {}", (Object)userId);
        }
        Object object = this.lock;
        synchronized (object) {
            this.doCheck();
            sessionId = this.userDefaultSessionIds.get(userId);
            if (sessionId != null) {
                session = this.sessions.get(sessionId);
            }
        }
        if (session == null) {
            if (sessionId != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No default session {} for user {}. Creating a new session", (Object)sessionId, (Object)userId);
                }
                this.removeSession(userId, sessionId);
            }
            session = this.createNewSession(user);
            sessionId = session.getSessionId();
            object = this.lock;
            synchronized (object) {
                sessionId = this.userDefaultSessionIds.putIfAbsent(userId, sessionId);
            }
            if (sessionId != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Another default session {} was created for user {}. That session will be used instead", (Object)sessionId, (Object)userId);
                }
                this.removeSession(userId, session.getSessionId());
                session.expire();
                return this.getDefaultSession(user);
            }
        } else if (session.isExpired()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The default session {} for user {} has expired. Creating a new session", (Object)sessionId, (Object)userId);
            }
            this.removeSession(userId, sessionId);
            session = this.getDefaultSession(user);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Located default session {} for user {}", (Object)sessionId, (Object)userId);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(String userId, String sessionId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing session {} for user {}", (Object)sessionId, (Object)userId);
        }
        Object object = this.lock;
        synchronized (object) {
            this.doCheck();
            this.userDefaultSessionIds.remove(userId, sessionId);
            this.sessionsByUser.computeIfPresent(userId, (k, v) -> v.stream().filter(s -> !s.equals(sessionId)).collect(Collectors.toCollection(LinkedHashSet::new)));
            this.sessions.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensiNactSession getSession(UserInfo user, String sessionId) {
        Objects.requireNonNull(user);
        SensiNactSessionImpl session = null;
        String userId = user.getUserId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting session {} for user {}", (Object)sessionId, (Object)userId);
        }
        Object object = this.lock;
        synchronized (object) {
            this.doCheck();
            if (this.sessionsByUser.getOrDefault(userId, Set.of()).contains(sessionId)) {
                session = this.sessions.get(sessionId);
            }
        }
        if (session != null && session.isExpired()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {} for user {} has expired", (Object)sessionId, (Object)userId);
            }
            this.removeSession(userId, sessionId);
            session = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning session {} for user {}", (Object)(session == null ? null : sessionId), (Object)userId);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSessionIds(UserInfo user) {
        List<String> ids;
        Objects.requireNonNull(user);
        String userId = user.getUserId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving active session ids for user {}", (Object)userId);
        }
        Object object = this.lock;
        synchronized (object) {
            this.doCheck();
            ids = this.sessionsByUser.getOrDefault(userId, Set.of()).stream().collect(Collectors.toList());
        }
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            SensiNactSession session;
            String sessionId = (String)it.next();
            Object object2 = this.lock;
            synchronized (object2) {
                session = this.sessions.get(sessionId);
            }
            if (session != null && !session.isExpired()) continue;
            this.removeSession(userId, sessionId);
            it.remove();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("User {} has sessions {}", (Object)userId, ids);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SensiNactSession createNewSession(UserInfo user) {
        boolean authChanged;
        SensiNactSessionImpl session;
        DefaultAuthPolicy policy;
        AuthorizationEngine auth;
        Objects.requireNonNull(user);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating a new session for user {}", (Object)user.getUserId());
        }
        Object object = this.lock;
        synchronized (object) {
            this.doCheck();
            auth = this.authEngine;
            policy = this.config.auth_policy();
        }
        if (auth == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No Authorization Engine is set. Using policy {}", (Object)policy);
            }
            session = new SensiNactSessionImpl(user, new DefaultSessionAuthorizationEngine(policy).createAuthorizer(user), this.thread);
        } else {
            session = new SensiNactSessionImpl(user, auth.createAuthorizer(user), this.thread);
        }
        String sessionId = session.getSessionId();
        Object object2 = this.lock;
        synchronized (object2) {
            if (auth == this.authEngine) {
                authChanged = false;
                this.sessionsByUser.merge(user.getUserId(), Set.of(sessionId), (a, b) -> Stream.concat(b.stream(), a.stream()).collect(Collectors.toCollection(LinkedHashSet::new)));
                this.sessions.put(sessionId, session);
            } else {
                authChanged = true;
            }
        }
        if (authChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The Authorization Engine changed. Recreating the new session");
            }
            return this.createNewSession(user);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created a new session {} for user {}", (Object)sessionId, (Object)user.getUserId());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(String topic, AbstractResourceNotification event) {
        ArrayList<SensiNactSessionImpl> sessions;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Manager received a notification on topic {}");
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            sessions = new ArrayList<SensiNactSessionImpl>(this.sessions.values());
        }
        for (SensiNactSessionImpl session : sessions) {
            if (!session.isExpired()) {
                try {
                    session.notify(topic, event);
                }
                catch (Exception exception) {}
                continue;
            }
            this.removeSession(session.getUserInfo().getUserId(), session.getSessionId());
        }
    }

    public SensiNactSession getDefaultAnonymousSession() {
        return this.getDefaultSession(UserInfo.ANONYMOUS);
    }

    public SensiNactSession getAnonymousSession(String sessionId) {
        return this.getSession(UserInfo.ANONYMOUS, sessionId);
    }

    public List<String> getAnonymousSessionIds() {
        return this.getSessionIds(UserInfo.ANONYMOUS);
    }

    public SensiNactSession createNewAnonymousSession() {
        return this.createNewSession(UserInfo.ANONYMOUS);
    }

    public static @interface Config {
        public int expiry() default 600;

        public DefaultAuthPolicy auth_policy() default DefaultAuthPolicy.DENY_ALL;
    }
}

