/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.extract.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.dto.impl.AbstractUpdateDto;
import org.eclipse.sensinact.core.extract.impl.DataExtractor;
import org.eclipse.sensinact.core.extract.impl.GenericDtoDataExtractor;
import org.eclipse.sensinact.core.push.dto.BulkGenericDto;

public class BulkGenericDtoDataExtractor
implements DataExtractor {
    private final GenericDtoDataExtractor subMapper = new GenericDtoDataExtractor();

    @Override
    public List<? extends AbstractUpdateDto> getUpdates(Object update) {
        BulkGenericDto dto = this.checkCast(update);
        List list = dto.dtos == null ? Collections.emptyList() : dto.dtos;
        return list.stream().map(this.subMapper::getUpdates).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private BulkGenericDto checkCast(Object update) {
        try {
            return (BulkGenericDto)BulkGenericDto.class.cast(update);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The supplied update dto is not of the correct type to extract", e);
        }
    }
}

