/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl.snapshot;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.core.impl.snapshot.AbstractSnapshot;
import org.eclipse.sensinact.core.impl.snapshot.ProviderSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ResourceSnapshotImpl;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.model.core.provider.Service;

public class ServiceSnapshotImpl
extends AbstractSnapshot
implements ServiceSnapshot {
    private final List<ResourceSnapshotImpl> resources = new ArrayList<ResourceSnapshotImpl>();
    private final ProviderSnapshotImpl provider;
    private final Service modelService;

    public ServiceSnapshotImpl(ProviderSnapshotImpl parent, String serviceName, Service modelService, Instant timestamp) {
        super(serviceName, timestamp);
        this.provider = parent;
        this.modelService = modelService;
    }

    public String toString() {
        ProviderSnapshotImpl provider = this.getProvider();
        return String.format("ServiceSnapshot(%s/%s/%s, %s)", provider.getModelName(), provider.getName(), this.getName(), this.getSnapshotTime());
    }

    public ProviderSnapshotImpl getProvider() {
        return this.provider;
    }

    public Service getModelService() {
        return this.modelService;
    }

    public void add(ResourceSnapshotImpl rc) {
        this.resources.add(rc);
    }

    public List<ResourceSnapshotImpl> getResources() {
        return List.copyOf(this.resources);
    }
}

