/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.metrics.impl;

import org.eclipse.sensinact.core.metrics.IMetricsMultiGauge;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"sensinact.metrics.multigauge.names=jvm.memory.heap.free,jvm.memory.heap.max,jvm.memory.heap.total,jvm.memory.heap.used"})
public class JVMMetrics
implements IMetricsMultiGauge {
    private static final String PREFIX = "jvm.memory.heap.";
    static final String MEM_TOTAL = "jvm.memory.heap.total";
    static final String MEM_FREE = "jvm.memory.heap.free";
    static final String MEM_USED = "jvm.memory.heap.used";
    static final String MEM_MAX = "jvm.memory.heap.max";

    public Object gauge(String name) {
        Runtime rt = Runtime.getRuntime();
        switch (name) {
            case "jvm.memory.heap.free": {
                return rt.freeMemory();
            }
            case "jvm.memory.heap.max": {
                return rt.maxMemory();
            }
            case "jvm.memory.heap.total": {
                return rt.totalMemory();
            }
            case "jvm.memory.heap.used": {
                return rt.totalMemory() - rt.freeMemory();
            }
        }
        throw new RuntimeException("Unknown gauge name: " + name);
    }
}

