/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.nexus.emf;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.stream.Collectors;

public class NamingUtils {
    public static final String[] keywords = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};

    public static boolean isJavaKeyword(String name) {
        return Arrays.binarySearch(keywords, name) >= 0;
    }

    public static String asciiSanitizeName(String name, boolean isPath) {
        if (name == null || name.isBlank()) {
            return null;
        }
        if (isPath) {
            return Arrays.stream(name.split("/")).map(p -> NamingUtils.asciiSanitizeName(p, false)).collect(Collectors.joining("/"));
        }
        String normalized = Normalizer.normalize(name.strip(), Normalizer.Form.NFKD).replaceAll("\\p{M}", "");
        String sanitized = normalized.isEmpty() ? name.replaceAll(".", "_") : normalized.replaceAll("[^_A-Za-z0-9]", "_");
        if (sanitized.isEmpty()) {
            return "_";
        }
        if (!Character.isJavaIdentifierStart(sanitized.charAt(0)) || NamingUtils.isJavaKeyword(name)) {
            return "_" + sanitized;
        }
        return sanitized;
    }

    public static String firstToUpper(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String sanitizeName(String name, boolean isPath) {
        if (name == null || name.isBlank()) {
            return null;
        }
        if (isPath) {
            return Arrays.stream(name.split("/")).map(p -> NamingUtils.sanitizeName(p, false)).collect(Collectors.joining("/"));
        }
        String sanitized = name.strip().chars().mapToObj(c -> Character.isJavaIdentifierPart(c) || isPath && c == 47 ? Character.toString((char)c) : "_").collect(Collectors.joining());
        if (sanitized.isEmpty()) {
            return "_";
        }
        if (!Character.isJavaIdentifierStart(sanitized.charAt(0)) || NamingUtils.isJavaKeyword(name)) {
            return "_" + sanitized;
        }
        return NamingUtils.firstToUpper(sanitized);
    }

    static {
        Arrays.sort(keywords);
    }
}

