/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.twin.impl;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFDigitalTwin;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFProvider;
import org.eclipse.sensinact.core.impl.snapshot.ProviderSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ResourceSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ServiceSnapshotImpl;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.core.snapshot.ServiceSnapshot;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.twin.impl.SensinactProviderImpl;
import org.eclipse.sensinact.core.twin.impl.SensinactResourceImpl;
import org.eclipse.sensinact.core.twin.impl.SensinactServiceImpl;
import org.eclipse.sensinact.core.twin.impl.TimedValueImpl;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.osgi.util.promise.PromiseFactory;

public class SensinactDigitalTwinImpl
extends CommandScopedImpl
implements SensinactEMFDigitalTwin {
    private final ModelNexus nexusImpl;
    private final PromiseFactory pf;

    public SensinactDigitalTwinImpl(ModelNexus nexusImpl, PromiseFactory pf) {
        super(new AtomicBoolean(true));
        this.nexusImpl = nexusImpl;
        this.pf = pf;
    }

    public List<SensinactProviderImpl> getProviders() {
        this.checkValid();
        return this.nexusImpl.getProviders().stream().map(this::toProvider).collect(Collectors.toList());
    }

    public SensinactProviderImpl getProvider(EClass model, String id) {
        if (model != ProviderPackage.Literals.PROVIDER || !model.getEAllSuperTypes().contains((Object)ProviderPackage.Literals.PROVIDER)) {
            throw new IllegalArgumentException("The requested eClass must have Provider as a super class");
        }
        Provider provider = this.nexusImpl.getProvider(model, id);
        if (provider == null) {
            return null;
        }
        return this.toProvider(provider);
    }

    public List<SensinactProviderImpl> getProviders(String modelPackageUri, String model) {
        this.checkValid();
        return this.nexusImpl.getProviders(modelPackageUri, model).stream().map(this::toProvider).collect(Collectors.toList());
    }

    public SensinactProviderImpl getProvider(String modelPackageUri, String model, String providerName) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(modelPackageUri, model, providerName);
        if (provider == null) {
            return null;
        }
        return this.toProvider(provider);
    }

    public SensinactProviderImpl getProvider(String providerName) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(providerName);
        if (provider == null) {
            return null;
        }
        return this.toProvider(provider);
    }

    public SensinactEMFProvider createProvider(String modelPackageUri, String model, String providerName) {
        return this.toProvider(this.nexusImpl.createProviderInstance(modelPackageUri, model, providerName));
    }

    public SensinactEMFProvider createProvider(String modelPackageUri, String model, String providerName, Instant instant) {
        return instant == null ? this.createProvider(model, providerName) : this.toProvider(this.nexusImpl.createProviderInstance(modelPackageUri, model, providerName, instant));
    }

    public SensinactEMFProvider createProvider(Provider provider) {
        return this.createProvider(provider.eClass().getEPackage().getNsURI(), EMFUtil.getModelName(provider.eClass()), provider.getId());
    }

    public SensinactServiceImpl getService(String modelPackageUri, String model, String providerName, String service) {
        this.checkValid();
        return this.getService(this.nexusImpl.getProvider(modelPackageUri, model, providerName), model, service);
    }

    public SensinactServiceImpl getService(String providerName, String service) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(providerName);
        return this.getService(provider, this.nexusImpl.getProviderModel(providerName), service);
    }

    public SensinactService getService(String model, String providerName, String service) {
        return this.getService(null, model, providerName, service);
    }

    private SensinactServiceImpl getService(Provider provider, String model, String serviceName) {
        if (provider == null) {
            return null;
        }
        EClass serviceType = provider.getServiceEClass(serviceName);
        if (serviceType == null) {
            return null;
        }
        SensinactProviderImpl snProvider = this.toProvider(provider);
        return this.toService(provider, serviceName, serviceType, snProvider);
    }

    public SensinactResource getResource(String model, String providerName, String service, String resource) {
        return this.getResource(null, model, providerName, service, resource);
    }

    public SensinactResourceImpl getResource(String modelPackageUri, String model, String providerName, String service, String resource) {
        this.checkValid();
        return this.getResource(this.nexusImpl.getProvider(modelPackageUri, model, providerName), model, service, resource);
    }

    public SensinactResourceImpl getResource(String providerName, String service, String resource) {
        this.checkValid();
        Provider provider = this.nexusImpl.getProvider(providerName);
        return this.getResource(provider, this.nexusImpl.getProviderModel(providerName), service, resource);
    }

    private SensinactResourceImpl getResource(Provider provider, String model, String serviceName, String resource) {
        if (provider == null) {
            return null;
        }
        EClass serviceEClass = provider.getServiceEClass(serviceName);
        if (serviceEClass == null) {
            return null;
        }
        ETypedElement rcFeature = Optional.ofNullable(serviceEClass.getEStructuralFeature(resource)).map(ETypedElement.class::cast).or(() -> serviceEClass.getEOperations().stream().filter(o -> o.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(o -> resource.equals(o.getName())).map(ETypedElement.class::cast).findFirst()).orElseGet(() -> null);
        if (rcFeature == null) {
            return null;
        }
        SensinactProviderImpl snProvider = this.toProvider(provider);
        SensinactServiceImpl snService = this.toService(provider, serviceName, serviceEClass, snProvider);
        return this.toResource(snService, provider, serviceName, rcFeature);
    }

    public <T> TimedValue<T> getResourceValue(String modelPackageUri, String model, String providerName, String service, String resource, Class<T> type) {
        this.checkValid();
        return this.getResourceValue(this.nexusImpl.getProvider(modelPackageUri, model, providerName), service, resource, type);
    }

    public <T> TimedValue<T> getResourceValue(String providerName, String service, String resource, Class<T> type) {
        this.checkValid();
        return this.getResourceValue(this.nexusImpl.getProvider(providerName), service, resource, type);
    }

    private <T> TimedValue<T> getResourceValue(Provider provider, String serviceName, String resource, Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Resource type must not be null");
        }
        if (provider == null) {
            return null;
        }
        Service svc = provider.getService(serviceName);
        if (svc == null) {
            return null;
        }
        EStructuralFeature rcFeature = svc.eClass().getEStructuralFeature(resource);
        if (rcFeature == null) {
            return null;
        }
        Metadata metadata = (Metadata)svc.getMetadata().get((Object)rcFeature);
        Instant timestamp = metadata != null ? metadata.getTimestamp() : null;
        Object rawValue = svc.eGet(rcFeature);
        if (rawValue == null) {
            return new TimedValueImpl<Object>(null, timestamp);
        }
        if (!type.isAssignableFrom(rawValue.getClass())) {
            throw new IllegalArgumentException("Expected a " + type.getName() + " but resource is a " + rawValue.getClass().getName());
        }
        return new TimedValueImpl<T>(type.cast(rawValue), timestamp);
    }

    private SensinactProviderImpl toProvider(Provider modelProvider) {
        return new SensinactProviderImpl(this.active, modelProvider, this.nexusImpl, this.pf);
    }

    private SensinactResourceImpl toResource(SensinactService parent, Provider provider, String serviceName, ETypedElement rcFeature) {
        return new SensinactResourceImpl(this.active, parent, provider, serviceName, rcFeature, rcFeature.getEType().getInstanceClass(), this.nexusImpl, this.pf);
    }

    private SensinactServiceImpl toService(Provider provider, String serviceName, EClass serviceEClass, SensinactProviderImpl snProvider) {
        return new SensinactServiceImpl(this.active, (SensinactProvider)snProvider, provider, serviceName, serviceEClass, this.nexusImpl, this.pf);
    }

    private void fillInResource(ResourceSnapshotImpl rcSnapshot) {
        if (rcSnapshot.getResourceType() == ResourceType.ACTION) {
            return;
        }
        ETypedElement rcFeature = rcSnapshot.getFeature();
        Service svc = rcSnapshot.getService().getModelService();
        if (!svc.eIsSet((EStructuralFeature)rcFeature)) {
            return;
        }
        Metadata metadata = svc == null ? null : (Metadata)svc.getMetadata().get((Object)rcFeature);
        Instant timestamp = metadata != null ? metadata.getTimestamp() : null;
        rcSnapshot.setValue(new TimedValueImpl<Object>((svc == null ? null : svc.eGet((EStructuralFeature)rcFeature)), timestamp));
    }

    public List<ProviderSnapshot> filteredSnapshot(Predicate<GeoJsonObject> geoFilter, Predicate<ProviderSnapshot> providerFilter, Predicate<ServiceSnapshot> svcFilter, Predicate<ResourceSnapshot> rcFilter) {
        Instant snapshotTime = Instant.now();
        Stream<ProviderSnapshotImpl> providersStream = this.nexusImpl.getProviders().stream().map(p -> new ProviderSnapshotImpl(p.eClass().getEPackage().getNsURI(), EMFUtil.getModelName(p.eClass()), (Provider)p, snapshotTime));
        if (providerFilter != null) {
            providersStream = providersStream.filter(providerFilter);
        }
        if (geoFilter != null) {
            providersStream = providersStream.filter(p -> geoFilter.test(p.getModelProvider().getAdmin().getLocation()));
        }
        providersStream = providersStream.map(p -> {
            Provider modelProvider = p.getModelProvider();
            this.nexusImpl.getServiceInstancesForProvider(modelProvider).forEach((k, v) -> p.add(new ServiceSnapshotImpl((ProviderSnapshotImpl)p, (String)k, (Service)v, snapshotTime)));
            return p;
        });
        if (svcFilter != null) {
            providersStream = providersStream.filter(p -> p.getServices().stream().anyMatch(svcFilter));
        }
        providersStream = providersStream.map(p -> {
            p.getServices().stream().forEach(s -> this.nexusImpl.getResourcesForService(s.getModelService().eClass()).forEach(f -> s.add(new ResourceSnapshotImpl((ServiceSnapshotImpl)s, (ETypedElement)f, snapshotTime))));
            return p;
        });
        if (rcFilter != null) {
            providersStream = providersStream.filter(p -> p.getServices().stream().anyMatch(s -> s.getResources().stream().anyMatch(rcFilter)));
        }
        providersStream = providersStream.map(p -> {
            p.getServices().stream().forEach(s -> s.getResources().stream().forEach(this::fillInResource));
            p.filterEmptyServices();
            return p;
        });
        return providersStream.collect(Collectors.toList());
    }

    public ProviderSnapshot snapshotProvider(String providerName) {
        Instant snapshotTime = Instant.now();
        Provider nexusProvider = this.nexusImpl.getProvider(providerName);
        if (nexusProvider == null) {
            return null;
        }
        ProviderSnapshotImpl providerSnapshot = new ProviderSnapshotImpl(this.nexusImpl.getProviderPackageUri(nexusProvider.getId()), this.nexusImpl.getProviderModel(nexusProvider.getId()), nexusProvider, snapshotTime);
        this.nexusImpl.getServiceInstancesForProvider(nexusProvider).forEach((serviceName, service) -> {
            ServiceSnapshotImpl svcSnapshot = new ServiceSnapshotImpl(providerSnapshot, (String)serviceName, (Service)service, snapshotTime);
            this.nexusImpl.getResourcesForService(service.eClass()).forEach(rcFeature -> {
                ResourceSnapshotImpl rcSnapshot = new ResourceSnapshotImpl(svcSnapshot, (ETypedElement)rcFeature, snapshotTime);
                this.fillInResource(rcSnapshot);
                svcSnapshot.add(rcSnapshot);
            });
            providerSnapshot.add(svcSnapshot);
        });
        providerSnapshot.filterEmptyServices();
        return providerSnapshot;
    }

    public ServiceSnapshot snapshotService(String providerName, String serviceName) {
        Instant snapshotTime = Instant.now();
        Provider nexusProvider = this.nexusImpl.getProvider(providerName);
        if (nexusProvider == null) {
            return null;
        }
        Service service = this.nexusImpl.getServiceInstancesForProvider(nexusProvider).get(serviceName);
        if (service == null) {
            return null;
        }
        ProviderSnapshotImpl providerSnapshot = new ProviderSnapshotImpl(this.nexusImpl.getProviderPackageUri(nexusProvider.getId()), this.nexusImpl.getProviderModel(nexusProvider.getId()), nexusProvider, snapshotTime);
        ServiceSnapshotImpl svcSnapshot = new ServiceSnapshotImpl(providerSnapshot, serviceName, service, snapshotTime);
        providerSnapshot.add(svcSnapshot);
        EStructuralFeature sf = nexusProvider.eClass().getEStructuralFeature(svcSnapshot.getName());
        this.nexusImpl.getResourcesForService((EClass)sf.getEType()).forEach(rcFeature -> {
            ResourceSnapshotImpl rcSnapshot = new ResourceSnapshotImpl(svcSnapshot, (ETypedElement)rcFeature, snapshotTime);
            this.fillInResource(rcSnapshot);
            svcSnapshot.add(rcSnapshot);
        });
        return svcSnapshot;
    }

    public ResourceSnapshot snapshotResource(String providerName, String serviceName, String resourceName) {
        Instant snapshotTime = Instant.now();
        Provider nexusProvider = this.nexusImpl.getProvider(providerName);
        if (nexusProvider == null) {
            return null;
        }
        Service service = this.nexusImpl.getServiceInstancesForProvider(nexusProvider).get(serviceName);
        if (service == null) {
            return null;
        }
        EStructuralFeature sf = nexusProvider.eClass().getEStructuralFeature(serviceName);
        Optional<ETypedElement> foundRc = this.nexusImpl.getResourcesForService((EClass)sf.getEType()).filter(f -> f.getName().equals(resourceName)).findFirst();
        if (foundRc.isEmpty()) {
            return null;
        }
        ProviderSnapshotImpl providerSnapshot = new ProviderSnapshotImpl(this.nexusImpl.getProviderPackageUri(nexusProvider.getId()), this.nexusImpl.getProviderModel(nexusProvider.getId()), nexusProvider, snapshotTime);
        ServiceSnapshotImpl svcSnapshot = new ServiceSnapshotImpl(providerSnapshot, serviceName, service, snapshotTime);
        providerSnapshot.add(svcSnapshot);
        ResourceSnapshotImpl rcSnapshot = new ResourceSnapshotImpl(svcSnapshot, foundRc.get(), snapshotTime);
        this.fillInResource(rcSnapshot);
        svcSnapshot.add(rcSnapshot);
        return rcSnapshot;
    }

    public List<? extends SensinactEMFProvider> getProviders(String model) {
        return this.getProviders(null, model);
    }

    public SensinactEMFProvider getProvider(String model, String providerName) {
        return this.getProvider(null, model, providerName);
    }

    public SensinactEMFProvider createProvider(String model, String providerName) {
        return this.createProvider(null, model, providerName);
    }

    public SensinactEMFProvider createProvider(String model, String providerName, Instant created) {
        return this.createProvider(null, model, providerName, created);
    }
}

