/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.twin.impl;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFProvider;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.impl.SensinactServiceImpl;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class SensinactProviderImpl
extends CommandScopedImpl
implements SensinactEMFProvider {
    private final Provider provider;
    private final ModelNexus nexus;
    private final PromiseFactory promiseFactory;

    public SensinactProviderImpl(AtomicBoolean active, Provider provider, ModelNexus nexus, PromiseFactory promiseFactory) {
        super(active);
        this.provider = provider;
        this.nexus = nexus;
        this.promiseFactory = promiseFactory;
    }

    public Map<String, SensinactService> getServices() {
        this.checkValid();
        return this.nexus.getDefinedServiceForProvider(this.provider).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SensinactServiceImpl(this.active, (SensinactProvider)this, this.provider, (String)e.getKey(), (EClass)e.getValue(), this.nexus, this.promiseFactory)));
    }

    public String getName() {
        this.checkValid();
        return this.provider.getId();
    }

    public String getModelName() {
        this.checkValid();
        return EMFUtil.getModelName(this.provider.eClass());
    }

    public String getModelPackageUri() {
        this.checkValid();
        return this.provider.eClass().getEPackage().getNsURI();
    }

    public String toString() {
        this.checkValid();
        return String.format("SensiNactProvider(model=%s, name=%s, services=%s)", this.getModelName(), this.getName(), this.getServices().keySet());
    }

    public List<SensinactEMFProvider> getLinkedProviders() {
        this.checkValid();
        return this.provider.getLinkedProviders().stream().map(p -> new SensinactProviderImpl(this.active, this.provider, this.nexus, this.promiseFactory)).collect(Collectors.toList());
    }

    public void addLinkedProvider(SensinactProvider provider) {
        this.checkValid();
        this.nexus.linkProviders(this.getName(), provider.getName(), Instant.now());
    }

    public void removeLinkedProvider(SensinactProvider provider) {
        this.checkValid();
        this.nexus.unlinkProviders(this.getName(), provider.getName(), Instant.now());
    }

    public void delete() {
        this.checkValid();
        this.nexus.deleteProvider(this.provider.eClass().getEPackage().getNsURI(), this.getModelName(), this.getName());
    }

    public Promise<Void> update(Provider newVersion) {
        this.checkValid();
        if (!newVersion.eClass().equals(newVersion.eClass())) {
            return this.promiseFactory.failed((Throwable)new IllegalArgumentException("The given Object is of type " + newVersion.eClass() + " but expected " + this.provider.eClass()));
        }
        this.nexus.save(newVersion);
        return this.promiseFactory.resolved(null);
    }
}

