/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.whiteboard.impl;

import java.util.Objects;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;

class RegistryKey {
    private final String modelPackageUri;
    private final String model;
    private final String service;
    private final String resource;

    public RegistryKey(String modelPackageUri, String model, String service, String resource) {
        this.modelPackageUri = modelPackageUri == null || modelPackageUri.isBlank() || "<<NOT_SET>>".equals(modelPackageUri) ? EMFUtil.constructPackageUri(model) : modelPackageUri;
        this.model = model;
        this.service = service;
        this.resource = resource;
    }

    public String getModelPackageUri() {
        return this.modelPackageUri;
    }

    public String getModel() {
        return this.model;
    }

    public String getService() {
        return this.service;
    }

    public String getResource() {
        return this.resource;
    }

    public int hashCode() {
        return Objects.hash(this.model, this.resource, this.service);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistryKey other = (RegistryKey)obj;
        return Objects.equals(this.modelPackageUri, other.modelPackageUri) && Objects.equals(this.model, other.model) && Objects.equals(this.resource, other.resource) && Objects.equals(this.service, other.service);
    }

    public String toString() {
        return "RegistryKey [modelPackageUri=" + this.modelPackageUri + ", model=" + this.model + ", service=" + this.service + ", resource=" + this.resource + "]";
    }
}

