/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationProvider;

public class DispatcherHelper {
    public static Set<JerseyApplicationProvider> getDefaultApplications(Collection<JerseyApplicationProvider> applications) {
        if (applications == null) {
            return Collections.emptySet();
        }
        Set resultSet = applications.stream().filter(JerseyApplicationProvider::isDefault).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        return resultSet;
    }

    public static Optional<JerseyApplicationProvider> getDefaultApplication(Collection<JerseyApplicationProvider> applications) {
        if (applications == null) {
            return Optional.empty();
        }
        return DispatcherHelper.getDefaultApplications(applications).stream().findFirst();
    }
}

