/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.osgitech.rest.annotations.RequireJerseyServlet;
import org.eclipse.osgitech.rest.provider.jakartars.RuntimeDelegateService;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

@RequireJerseyServlet
public class WhiteboardServletContainer
extends ServletContainer {
    private static final long serialVersionUID = 6509888299005723799L;
    private ResourceConfig initialConfig = null;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public WhiteboardServletContainer(ResourceConfig config) {
        this.initialConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        this.lock.writeLock().lock();
        try {
            ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(RuntimeDelegateService.class.getClassLoader());
                super.init();
                Future<?> future = Executors.newSingleThreadExecutor().submit(() -> {
                    ApplicationHandler handler = this.getApplicationHandler();
                    while (handler.getInjectionManager() == null) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                });
                future.get();
                this.initialized.set(true);
                if (this.initialConfig != null) {
                    this.reload(this.initialConfig);
                    this.initialConfig = null;
                }
            }
            catch (Exception e) {
                if (e instanceof ServletException) {
                    throw (ServletException)e;
                }
                throw new ServletException((Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTccl);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ResourceConfig configuration) {
        block8: {
            this.lock.writeLock().lock();
            try {
                if (this.initialized.get()) {
                    try {
                        super.reload(configuration);
                        break block8;
                    }
                    catch (IllegalStateException ise) {
                        if (!this.getApplicationHandler().getInjectionManager().isShutdown()) break block8;
                        try {
                            this.initialConfig = configuration;
                            this.init();
                            break block8;
                        }
                        catch (ServletException e) {
                            throw ise;
                        }
                    }
                }
                this.initialConfig = configuration;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.lock.readLock().lock();
        try {
            super.service(request, response);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void destroy() {
        this.lock.writeLock().lock();
        try {
            this.initialized.set(false);
            super.destroy();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ResourceConfig getConfiguration() {
        this.lock.readLock().lock();
        try {
            if (this.initialConfig != null) {
                ResourceConfig resourceConfig = this.initialConfig;
                return resourceConfig;
            }
            ResourceConfig resourceConfig = super.getConfiguration();
            return resourceConfig;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void dispose() {
    }
}

