/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.application;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgitech.rest.helper.JerseyHelper;
import org.eclipse.osgitech.rest.provider.JakartarsConstants;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public abstract class AbstractJakartarsProvider<T>
implements JakartarsConstants,
Comparable<AbstractJakartarsProvider<?>> {
    private static final Filter IMPOSSIBLE_MATCH;
    private static final Logger logger;
    private final Map<String, Object> properties;
    private String name;
    private String id;
    private Long serviceId;
    private Integer serviceRank;
    private int status = -1;
    private Filter whiteboardTargetFilter;
    private List<Filter> extensionFilters = new LinkedList<Filter>();
    private T providerObject;

    public AbstractJakartarsProvider(T providerObject, Map<String, Object> properties) {
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.providerObject = providerObject;
        this.validateProperties();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getServiceId() {
        return this.serviceId;
    }

    public Integer getServiceRank() {
        return this.serviceRank;
    }

    public boolean isFailed() {
        return this.getProviderStatus() != -1;
    }

    public Map<String, Object> getProviderProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean requiresExtensions() {
        return !this.extensionFilters.isEmpty();
    }

    public boolean canHandleWhiteboard(Map<String, Object> runtimeProperties) {
        if (this.whiteboardTargetFilter == null) {
            return true;
        }
        runtimeProperties = Objects.isNull(runtimeProperties) ? Collections.emptyMap() : runtimeProperties;
        boolean match = this.whiteboardTargetFilter.matches(runtimeProperties);
        return match;
    }

    public List<Filter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public T getProviderObject() {
        return this.providerObject;
    }

    protected int getProviderStatus() {
        return this.status;
    }

    protected void setProviderName(String name) {
        this.name = name;
    }

    protected String calculateProviderId() {
        Long serviceId = this.getServiceId();
        if (Objects.isNull(serviceId)) {
            return "." + UUID.randomUUID().toString();
        }
        return "sid_" + serviceId;
    }

    protected String getProviderName() {
        String jakartarsName;
        String providerName = this.calculateProviderId();
        if (this.properties != null && (jakartarsName = (String)this.properties.get("osgi.jakartars.name")) != null) {
            providerName = jakartarsName;
            if (jakartarsName.startsWith("osgi") || jakartarsName.startsWith(".")) {
                this.updateStatus(3);
            }
        }
        return providerName;
    }

    protected void validateProperties() {
        String[] filters;
        this.updateStatus(-1);
        this.serviceId = AbstractJakartarsProvider.getServiceId(this.properties);
        this.id = this.calculateProviderId();
        this.name = this.getProviderName();
        Object sr = this.properties.get("service.ranking");
        this.serviceRank = sr != null && sr instanceof Integer ? (Integer)sr : Integer.valueOf(0);
        String filter = (String)this.properties.get("osgi.jakartars.whiteboard.target");
        if (filter != null) {
            try {
                this.whiteboardTargetFilter = FrameworkUtil.createFilter((String)filter);
            }
            catch (InvalidSyntaxException e) {
                logger.log(Level.SEVERE, "The given whiteboard target filter is invalid: " + filter);
                this.updateStatus(3);
                this.whiteboardTargetFilter = IMPOSSIBLE_MATCH;
            }
        }
        if ((filters = JerseyHelper.getStringPlusProperty("osgi.jakartars.extension.select", this.properties)) != null) {
            for (String f : filters) {
                try {
                    Filter extensionFilter = FrameworkUtil.createFilter((String)f);
                    this.extensionFilters.add(extensionFilter);
                }
                catch (InvalidSyntaxException e) {
                    logger.log(Level.SEVERE, "The given extension select filter is invalid: " + filter, e);
                    this.extensionFilters.clear();
                    this.updateStatus(3);
                    break;
                }
            }
        }
        this.extensionFilters = List.copyOf(this.extensionFilters);
        this.doValidateProperties(this.properties);
    }

    public static Long getServiceId(Map<String, Object> properties) {
        Long serviceId = (Long)properties.get("service.id");
        if (serviceId == null) {
            serviceId = (Long)properties.get("component.id");
        }
        return serviceId;
    }

    protected abstract void doValidateProperties(Map<String, Object> var1);

    public void updateStatus(int newStatus) {
        if (newStatus == this.status) {
            return;
        }
        if (this.status == -1) {
            this.status = newStatus;
        } else if (newStatus != this.status) {
            this.status = newStatus;
        }
    }

    public abstract AbstractJakartarsProvider<T> cleanCopy();

    @Override
    public final int compareTo(AbstractJakartarsProvider<?> o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Long si = this.getServiceId();
        Long si2 = o.getServiceId();
        if (si != null && si.equals(si2)) {
            return 0;
        }
        Integer sr = this.getServiceRank();
        sr = sr == null ? 0 : sr;
        Integer sr2 = o.getServiceRank();
        int r = (sr2 = Integer.valueOf(sr2 == null ? 0 : sr2)).compareTo(sr);
        if (r == 0) {
            if (si != null) {
                if (si2 != null) {
                    return si.compareTo(si2);
                }
                r = -1;
            } else {
                r = si2 != null ? 1 : this.getName().compareTo(o.getName());
            }
        }
        return r;
    }

    static {
        try {
            IMPOSSIBLE_MATCH = FrameworkUtil.createFilter((String)"(&(foo=bar)(!(foo=bar)))");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("The filter failed to be created", e);
        }
        logger = Logger.getLogger("jersey.abstractProvider");
    }
}

