/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgitech.rest.helper.JerseyHelper;
import org.eclipse.osgitech.rest.runtime.application.AbstractJakartarsProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationProvider;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceObjects;

public abstract class JerseyApplicationContentProvider
extends AbstractJakartarsProvider<ServiceObjects<Object>> {
    private static final Logger logger = Logger.getLogger("jersey.contentProvider");
    private List<Filter> applicationFilter;
    private Class<? extends Object> clazz;

    public JerseyApplicationContentProvider(ServiceObjects<Object> serviceObjects, Map<String, Object> properties) {
        super(serviceObjects, properties);
        serviceObjects = (ServiceObjects)this.getProviderObject();
        if (serviceObjects != null) {
            Object service = null;
            try {
                service = serviceObjects.getService();
            }
            catch (Exception e) {
                logger.warning("Error getting the service " + e.getMessage());
            }
            if (service != null) {
                this.clazz = service.getClass();
                try {
                    serviceObjects.ungetService(service);
                }
                catch (Throwable e) {
                    this.updateStatus(2);
                }
            } else {
                this.updateStatus(2);
            }
        } else {
            this.updateStatus(2);
        }
    }

    public boolean isSingleton() {
        String scope = (String)this.getProviderProperties().get("service.scope");
        return !"prototype".equalsIgnoreCase(scope);
    }

    public Class<?> getObjectClass() {
        return this.clazz;
    }

    public boolean canHandleApplication(JerseyApplicationProvider application) {
        block7: {
            if (this.applicationFilter != null && !this.applicationFilter.isEmpty()) {
                try {
                    boolean applicationMatch = this.applicationFilter.stream().anyMatch(f -> f.matches(application.getProviderProperties()));
                    if (!applicationMatch) {
                        logger.log(Level.FINE, "[" + this.getId() + "] The given application select filter does not match to this application " + application.getId() + " for this resource/extension: " + this.getId());
                        return false;
                    }
                    break block7;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "The given application select filter causes an error: " + this.applicationFilter, e);
                    return false;
                }
            }
            if (application.isShadowDefault()) {
                return false;
            }
            if (!application.isDefault()) {
                if (".default".equals(application.getName()) || "/".equals(application.getPath()) || "/*".equals(application.getPath())) {
                    logger.fine("Potential default app " + application.getName() + " can handle content");
                    return true;
                }
                logger.log(Level.INFO, "[" + this.getId() + "] There is no application select filter defined, using default application");
                return false;
            }
            return this.canHandleDefaultApplication();
        }
        return true;
    }

    private boolean canHandleDefaultApplication() {
        if (this.applicationFilter == null || this.applicationFilter.isEmpty()) {
            return true;
        }
        Map<String, String> properties = Collections.singletonMap("osgi.jakartars.name", ".default");
        return this.applicationFilter.stream().anyMatch(f -> f.matches(properties));
    }

    public abstract JerseyApplicationContentProvider cleanCopy();

    @Override
    protected void doValidateProperties(Map<String, Object> properties) {
        Object resourceProp = properties.get(this.getJakartarsResourceConstant());
        if (resourceProp == null || resourceProp instanceof Boolean && !((Boolean)resourceProp).booleanValue() || !Boolean.parseBoolean(resourceProp.toString())) {
            logger.log(Level.WARNING, "The resource to add is not declared with the resource property: " + this.getJakartarsResourceConstant());
            this.updateStatus(-10);
            return;
        }
        String[] filters = JerseyHelper.getStringPlusProperty("osgi.jakartars.application.select", properties);
        if (filters != null) {
            ArrayList<Filter> filterList = new ArrayList<Filter>(filters.length);
            for (String filter : filters) {
                try {
                    filterList.add(FrameworkUtil.createFilter((String)filter));
                }
                catch (InvalidSyntaxException e) {
                    logger.log(Level.SEVERE, "The given application select filter is invalid: " + filter, e);
                    this.updateStatus(3);
                    return;
                }
            }
            this.applicationFilter = filterList;
        }
    }

    protected abstract String getJakartarsResourceConstant();
}

