/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SensorthingsMapper;
import org.osgi.util.promise.Promise;

public class PropertyMapper
extends SensorthingsMapper<JsonNode> {
    private final SensorthingsMapper<?> mapper;
    private final Set<String> property;
    private final String provider;
    private final String service;
    private final String resource;

    public PropertyMapper(String topicFilter, String property, String provider, String service, String resource, SensorthingsMapper<?> mapper, ObjectMapper jsonMapper, GatewayThread thread) {
        super(topicFilter, jsonMapper, thread);
        this.provider = provider;
        this.service = service;
        this.resource = resource;
        this.mapper = mapper;
        this.property = Set.of(property);
    }

    @Override
    public Promise<Stream<JsonNode>> toPayload(AbstractResourceNotification notification) {
        if (this.match(this.provider, notification.provider) && this.match(this.service, notification.service) && this.match(this.resource, notification.resource)) {
            return this.mapper.toPayload(notification).map(s -> s.map(o -> ((ObjectNode)this.jsonMapper.convertValue(o, ObjectNode.class)).retain(this.property)));
        }
        return this.emptyStream();
    }

    private boolean match(String require, String value) {
        return require == null || require.equals(value);
    }

    @Override
    protected Class<JsonNode> getPayloadType() {
        return JsonNode.class;
    }
}

