/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;
import org.eclipse.sensinact.core.notification.LifecycleNotification;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.notification.ResourceMetaDataNotification;
import org.eclipse.sensinact.core.snapshot.ResourceSnapshot;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SensorthingsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.osgi.util.promise.Promise;

public class DatastreamsMapper
extends SensorthingsMapper<Datastream> {
    public DatastreamsMapper(String topicFilter, ObjectMapper mapper, GatewayThread thread) {
        super(topicFilter, mapper, thread);
    }

    @Override
    public Promise<Stream<Datastream>> toPayload(LifecycleNotification notification) {
        if (notification.resource != null && notification.status != LifecycleNotification.Status.RESOURCE_DELETED) {
            return this.getDatastream(this.getResource(notification.provider, notification.service, notification.resource));
        }
        return this.emptyStream();
    }

    @Override
    public Promise<Stream<Datastream>> toPayload(ResourceMetaDataNotification notification) {
        return this.getDatastream(this.getResource(notification.provider, notification.service, notification.resource));
    }

    @Override
    public Promise<Stream<Datastream>> toPayload(ResourceDataNotification notification) {
        if (this.isRelevantAdminResource((AbstractResourceNotification)notification)) {
            return this.mapProvider(this.getProvider(notification.provider), this::getDatastream);
        }
        return this.emptyStream();
    }

    protected Promise<Stream<Datastream>> getDatastream(Promise<ResourceSnapshot> resourceSnapshot) {
        return this.decorate(resourceSnapshot.map(r -> DtoMapper.toDatastream(this.jsonMapper, r)));
    }

    @Override
    protected Class<Datastream> getPayloadType() {
        return Datastream.class;
    }

    protected boolean isRelevantAdminResource(AbstractResourceNotification notification) {
        return "admin".equals(notification.service) && "location".equals(notification.resource);
    }
}

