/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.stream.Stream;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.notification.ResourceDataNotification;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.SensorthingsMapper;
import org.eclipse.sensinact.gateway.northbount.sensorthings.mqtt.mappers.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.osgi.util.promise.Promise;

public class ObservationsMapper
extends SensorthingsMapper<Observation> {
    public ObservationsMapper(String topicFilter, ObjectMapper mapper, GatewayThread thread) {
        super(topicFilter, mapper, thread);
    }

    @Override
    public Promise<Stream<Observation>> toPayload(final ResourceDataNotification notification) {
        TimedValue<Object> tv = new TimedValue<Object>(){

            public Instant getTimestamp() {
                return notification.timestamp;
            }

            public Object getValue() {
                return notification.newValue;
            }
        };
        return this.wrap(DtoMapper.toObservation(notification.provider, notification.service, notification.resource, tv));
    }

    @Override
    protected Class<Observation> getPayloadType() {
        return Observation.class;
    }
}

