/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;

public class ListenerInfo
extends WhiteboardServiceInfo<EventListener> {
    private static final Set<String> ALLOWED_INTERFACES = new HashSet<String>();
    private final boolean enabled;
    private final Set<String> types;
    private final String[] dtoTypes;

    public ListenerInfo(ServiceReference<EventListener> ref) {
        this(ref, ListenerInfo.getTypes(ref), null);
    }

    public ListenerInfo(ServiceReference<EventListener> ref, Set<String> types, String[] dtos) {
        super(ref);
        this.enabled = this.getBooleanProperty(ref, "osgi.http.whiteboard.listener");
        this.types = types;
        this.dtoTypes = dtos == null ? types.toArray(new String[types.size()]) : dtos;
    }

    private static Set<String> getTypes(ServiceReference<EventListener> ref) {
        String[] objectClass = (String[])ref.getProperty("objectClass");
        HashSet<String> names = new HashSet<String>();
        for (String name : objectClass) {
            if (!ALLOWED_INTERFACES.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.enabled;
    }

    @NotNull
    public String[] getDTOListenerTypes() {
        return this.dtoTypes;
    }

    public boolean isListenerType(@NotNull String className) {
        for (String t : this.types) {
            if (!t.equals(className)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> getListenerTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public String getType() {
        return "Listener";
    }

    static {
        ALLOWED_INTERFACES.add(HttpSessionAttributeListener.class.getName());
        ALLOWED_INTERFACES.add(HttpSessionIdListener.class.getName());
        ALLOWED_INTERFACES.add(HttpSessionListener.class.getName());
        ALLOWED_INTERFACES.add(ServletContextAttributeListener.class.getName());
        ALLOWED_INTERFACES.add(ServletContextListener.class.getName());
        ALLOWED_INTERFACES.add(ServletRequestAttributeListener.class.getName());
        ALLOWED_INTERFACES.add(ServletRequestListener.class.getName());
    }
}

