/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Self;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PropFilter;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.RefFilter;

@Produces(value={"application/json"})
@Path(value="/v1.1/Things({id})")
public interface ThingsAccess {
    @GET
    public Thing getThing(@PathParam(value="id") String var1);

    @Path(value="{prop}")
    @GET
    @PropFilter
    default public Thing getThingProp(@PathParam(value="id") String id) {
        return this.getThing(id);
    }

    @Path(value="{prop}/$value")
    @GET
    @PropFilter
    default public Thing getThingPropValue(@PathParam(value="id") String id) {
        return this.getThing(id);
    }

    @Path(value="Datastreams")
    @GET
    public ResultList<Datastream> getThingDatastreams(@PathParam(value="id") String var1);

    @Path(value="Datastreams/$ref")
    @GET
    @RefFilter
    default public ResultList<? extends Self> getThingDatastreamsRef(@PathParam(value="id") String id) {
        return this.getThingDatastreams(id);
    }

    @Path(value="Datastreams({id2})")
    @GET
    public Datastream getThingDatastream(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="Datastreams({id2})/{prop}")
    @GET
    @PropFilter
    default public Datastream getThingDatastreamProp(@PathParam(value="id") String id, @PathParam(value="id2") String id2) {
        return this.getThingDatastream(id, id2);
    }

    @Path(value="Datastreams({id2})/Observations")
    @GET
    public ResultList<Observation> getThingDatastreamObservations(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="Datastreams({id2})/ObservedProperty")
    @GET
    public ObservedProperty getThingDatastreamObservedProperty(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="Datastreams({id2})/Sensor")
    @GET
    public Sensor getThingDatastreamSensor(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="Datastreams({id2})/Thing")
    @GET
    public Thing getThingDatastreamThing(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="HistoricalLocations")
    @GET
    public ResultList<HistoricalLocation> getThingHistoricalLocations(@PathParam(value="id") String var1);

    @Path(value="HistoricalLocations/$ref")
    @GET
    @RefFilter
    default public ResultList<? extends Self> getThingHistoricalLocationsRef(@PathParam(value="id") String id) {
        return this.getThingHistoricalLocations(id);
    }

    @Path(value="HistoricalLocations({id2})")
    @GET
    public HistoricalLocation getThingHistoricalLocation(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="HistoricalLocations({id2})/{prop}")
    @GET
    @PropFilter
    default public HistoricalLocation getThingHistoricalLocationProp(@PathParam(value="id") String id, @PathParam(value="id2") String id2) {
        return this.getThingHistoricalLocation(id, id2);
    }

    @Path(value="HistoricalLocations({id2})/Thing")
    @GET
    public Thing getThingHistoricalLocationsThing(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="HistoricalLocations({id2})/Locations")
    @GET
    public ResultList<Location> getThingHistoricalLocationLocations(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="Locations")
    @GET
    public ResultList<Location> getThingLocations(@PathParam(value="id") String var1);

    @Path(value="Locations/$ref")
    @GET
    @RefFilter
    default public ResultList<? extends Self> getThingLocationsRef(@PathParam(value="id") String id) {
        return this.getThingLocations(id);
    }

    @Path(value="Locations({id2})")
    @GET
    public Location getThingLocation(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="Locations({id2})/{prop}")
    @GET
    @PropFilter
    default public Location getThingLocationProp(@PathParam(value="id") String id, @PathParam(value="id2") String id2) {
        return this.getThingLocation(id, id2);
    }

    @Path(value="Locations({id2})/Things")
    @GET
    public ResultList<Thing> getThingLocationThings(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);

    @Path(value="Locations({id2})/HistoricalLocations")
    @GET
    public ResultList<HistoricalLocation> getThingLocationHistoricalLocations(@PathParam(value="id") String var1, @PathParam(value="id2") String var2);
}

