/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.filters;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;

@Priority(value=4002)
public class SkipFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    static final String SKIP_PROP = "org.eclipse.sensinact.sensorthings.sensing.rest.skip";

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Integer skip = (Integer)requestContext.getProperty(SKIP_PROP);
        if (skip == null) {
            return;
        }
        Object entity = responseContext.getEntity();
        if (entity instanceof ResultList) {
            ResultList resultList = (ResultList)entity;
            int size = resultList.value.size();
            resultList.value = resultList.value.subList(Math.min(skip, size), size);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        int skip = 0;
        List list = (List)requestContext.getUriInfo().getQueryParameters().get((Object)"$skip");
        if (list == null) {
            return;
        }
        if (list.size() > 1) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Only one $skip parameter may be provided").build());
        } else if (!list.isEmpty()) {
            String s = (String)list.get(0);
            try {
                skip = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The $skip parameter must be an integer greater than zero").build());
            }
        }
        if (skip < 0) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The $skip parameter must be an integer greater than zero").build());
        }
        requestContext.setProperty(SKIP_PROP, (Object)skip);
    }
}

