/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.sensinact.northbound.query.dto.jackson.SensinactPathDeserializer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=SensinactPathDeserializer.class)
public class SensinactPath {
    public String provider;
    public String service;
    public String resource;
    public String metadata;

    public SensinactPath(String provider, String service, String resource, String metadata) {
        this.provider = provider;
        this.service = service;
        this.resource = resource;
        this.metadata = metadata;
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.service, this.resource, this.metadata);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SensinactPath)) {
            return false;
        }
        SensinactPath other = (SensinactPath)obj;
        return Objects.equals(this.provider, other.provider) && Objects.equals(this.service, other.service) && Objects.equals(this.resource, other.resource) && Objects.equals(this.metadata, other.metadata);
    }

    public SensinactPath(String provider, String service, String resource) {
        this(provider, service, resource, null);
    }

    public SensinactPath(String provider, String service) {
        this(provider, service, null, null);
    }

    public SensinactPath(String provider) {
        this(provider, null, null, null);
    }

    public SensinactPath() {
        this(null, null, null, null);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return !this.hasProvider() && !this.hasService() && !this.hasResource() && !this.hasMetadata();
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isBlank();
    }

    public boolean hasService() {
        return this.service != null && !this.service.isBlank();
    }

    public boolean hasResource() {
        return this.resource != null && !this.resource.isBlank();
    }

    public boolean hasMetadata() {
        return this.metadata != null && !this.metadata.isBlank();
    }

    public boolean targetsSpecificProvider() {
        return this.hasProvider() && this.service == null && this.resource == null && this.metadata == null;
    }

    public boolean targetsSpecificService() {
        return this.hasProvider() && this.hasService() && this.resource == null && this.metadata == null;
    }

    public boolean targetsSpecificResource() {
        return this.hasProvider() && this.hasService() && this.hasResource() && this.metadata == null;
    }

    public boolean targetsSpecificMetadata() {
        return this.hasProvider() && this.hasService() && this.hasResource() && this.hasMetadata();
    }

    public String toString() {
        return String.format("Path(provider=%s, service=%s, resource=%s, metadata=%s)", this.provider, this.service, this.resource, this.metadata);
    }

    public String toUri() {
        ArrayList<String> items = new ArrayList<String>(4);
        for (String item : Arrays.asList(this.provider, this.service, this.resource, this.metadata)) {
            if (item == null) break;
            items.add(item);
        }
        return "/" + String.join((CharSequence)"/", items);
    }

    private static String safeArrayGet(String[] array, int index) {
        if (index < array.length) {
            String value = array[index].trim();
            if (value.isEmpty()) {
                return null;
            }
            return value;
        }
        return null;
    }

    public static SensinactPath fromUri(String uri) throws IllegalArgumentException {
        SensinactPath path = new SensinactPath();
        if (uri == null || uri.isBlank()) {
            return path;
        }
        String[] parts = uri.split("/");
        if (parts.length >= 1 && !parts[0].isEmpty()) {
            throw new IllegalArgumentException("URI must start with a slash /");
        }
        path.provider = SensinactPath.safeArrayGet(parts, 1);
        path.service = SensinactPath.safeArrayGet(parts, 2);
        path.resource = SensinactPath.safeArrayGet(parts, 3);
        path.metadata = SensinactPath.safeArrayGet(parts, 4);
        return path;
    }
}

