/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.query.dto.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.util.Set;
import org.eclipse.sensinact.northbound.query.dto.SensinactPath;

public class SensinactPathDeserializer
extends StdDeserializer<SensinactPath> {
    private static final long serialVersionUID = 1L;

    public SensinactPathDeserializer() {
        this(null);
    }

    protected SensinactPathDeserializer(Class<?> vc) {
        super(vc);
    }

    public SensinactPath deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JacksonException {
        SensinactPath path;
        switch (parser.currentToken()) {
            case VALUE_STRING: {
                path = SensinactPath.fromUri(parser.getText());
                parser.nextToken();
                break;
            }
            case VALUE_NULL: {
                path = null;
                parser.nextToken();
                break;
            }
            case START_OBJECT: {
                path = this.parseObject(parser);
                break;
            }
            default: {
                throw MismatchedInputException.from((DeserializationContext)ctxt, (String)("Invalid node type " + parser.currentToken() + " expected text or null"));
            }
        }
        return path;
    }

    private SensinactPath parseObject(JsonParser parser) throws IOException {
        SensinactPath path = new SensinactPath();
        block16: while (true) {
            switch (parser.nextToken()) {
                case FIELD_NAME: {
                    String fieldName = parser.getText();
                    JsonToken valueType = parser.nextToken();
                    if (valueType == JsonToken.VALUE_NULL || valueType == JsonToken.VALUE_STRING) {
                        switch (fieldName) {
                            case "provider": {
                                path.provider = parser.getText();
                                continue block16;
                            }
                            case "service": {
                                path.service = parser.getText();
                                continue block16;
                            }
                            case "resource": {
                                path.resource = parser.getText();
                                continue block16;
                            }
                            case "metadata": {
                                path.metadata = parser.getText();
                                continue block16;
                            }
                        }
                        throw UnrecognizedPropertyException.from((JsonParser)parser, SensinactPath.class, (String)fieldName, Set.of("provider", "service", "resource", "metadata"));
                    }
                    throw MismatchedInputException.from((JsonParser)parser, SensinactPath.class, (String)("Invalid value type " + parser.currentToken() + " for field " + fieldName));
                }
                case END_OBJECT: {
                    return path;
                }
            }
            break;
        }
        throw MismatchedInputException.from((JsonParser)parser, SensinactPath.class, (String)("Invalid node type " + parser.currentToken() + " expected FIELD_NAME or END_OBJECT"));
    }
}

