/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.command;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.sensinact.core.command.GatewayThread;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public abstract class AbstractSensinactCommand<T> {
    private NotificationAccumulator accumulator;
    private final AtomicBoolean canRun = new AtomicBoolean(true);

    protected AbstractSensinactCommand() {
    }

    protected AbstractSensinactCommand(NotificationAccumulator accumulator) {
        this.accumulator = accumulator;
    }

    public final Promise<T> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr) throws Exception {
        GatewayThread gateway = GatewayThread.getGatewayThread();
        if (this.canRun.getAndSet(false)) {
            PromiseFactory promiseFactory = gateway.getPromiseFactory();
            return AbstractSensinactCommand.safeCall(this, twin, modelMgr, promiseFactory).onResolve(this.getAccumulator()::completeAndSend);
        }
        throw new IllegalStateException("Commands can only be executed once");
    }

    public NotificationAccumulator getAccumulator() {
        if (this.accumulator == null) {
            this.accumulator = GatewayThread.getGatewayThread().createAccumulator();
        }
        return this.accumulator;
    }

    protected abstract Promise<T> call(SensinactDigitalTwin var1, SensinactModelManager var2, PromiseFactory var3);

    protected static <R> Promise<R> safeCall(AbstractSensinactCommand<R> command, SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory pf) {
        try {
            return command.call(twin, modelMgr, pf);
        }
        catch (Throwable t) {
            return pf.failed(t);
        }
    }

    protected static <R> Promise<R> safeCall(Supplier<Promise<R>> supplier, PromiseFactory pf) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return pf.failed((Throwable)e);
        }
    }
}

