/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.command;

import org.eclipse.sensinact.core.command.AbstractTwinCommand;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public abstract class ResourceCommand<T>
extends AbstractTwinCommand<T> {
    private final String model;
    private final String provider;
    private final String service;
    private final String resource;
    private String packageUri;

    public ResourceCommand(String provider, String service, String resource) {
        this(null, null, provider, service, resource);
    }

    public ResourceCommand(String model, String provider, String service, String resource) {
        this(null, model, provider, service, resource);
    }

    public ResourceCommand(String packageUri, String model, String provider, String service, String resource) {
        this.packageUri = packageUri;
        this.model = model;
        this.provider = provider;
        this.service = service;
        this.resource = resource;
    }

    @Override
    protected final Promise<T> call(SensinactDigitalTwin twin, PromiseFactory pf) {
        SensinactResource r;
        SensinactResource sensinactResource = r = this.model == null ? twin.getResource(this.provider, this.service, this.resource) : twin.getResource(this.packageUri, this.model, this.provider, this.service, this.resource);
        if (r == null) {
            return pf.failed((Throwable)new IllegalArgumentException("Resource not found"));
        }
        return this.call(r, pf);
    }

    protected abstract Promise<T> call(SensinactResource var1, PromiseFactory var2);
}

