/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.notification;

import java.util.Map;
import java.util.Objects;
import org.eclipse.sensinact.core.notification.AbstractResourceNotification;

public class LifecycleNotification
extends AbstractResourceNotification {
    public Status status;
    public Object initialValue;
    public Map<String, Object> initialMetadata;

    @Override
    public String getTopic() {
        Objects.requireNonNull(this.status);
        Objects.requireNonNull(this.provider);
        int ordinal = this.status.ordinal();
        if (ordinal >= Status.SERVICE_CREATED.ordinal()) {
            Objects.requireNonNull(this.service);
        }
        if (ordinal >= Status.RESOURCE_CREATED.ordinal()) {
            Objects.requireNonNull(this.resource);
        }
        return String.format("LIFECYCLE/%s", String.format(this.status.template, this.provider, this.service, this.resource));
    }

    public static enum Status {
        PROVIDER_CREATED("%s"),
        PROVIDER_DELETED("%s"),
        SERVICE_CREATED("%s/%s"),
        SERVICE_DELETED("%s/%s"),
        RESOURCE_CREATED("%s/%s/%s"),
        RESOURCE_DELETED("%s/%s/%s");

        private final String template;

        private Status(String template) {
            this.template = template;
        }
    }
}

