/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.sensorthings.sensing.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.northbound.session.ProviderDescription;
import org.eclipse.sensinact.northbound.session.SensiNactSession;
import org.eclipse.sensinact.sensorthings.sensing.dto.Datastream;
import org.eclipse.sensinact.sensorthings.sensing.dto.HistoricalLocation;
import org.eclipse.sensinact.sensorthings.sensing.dto.Location;
import org.eclipse.sensinact.sensorthings.sensing.dto.Observation;
import org.eclipse.sensinact.sensorthings.sensing.dto.ObservedProperty;
import org.eclipse.sensinact.sensorthings.sensing.dto.ResultList;
import org.eclipse.sensinact.sensorthings.sensing.dto.Sensor;
import org.eclipse.sensinact.sensorthings.sensing.dto.Thing;
import org.eclipse.sensinact.sensorthings.sensing.rest.ThingsAccess;
import org.eclipse.sensinact.sensorthings.sensing.rest.annotation.PaginationLimit;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.DtoMapper;
import org.eclipse.sensinact.sensorthings.sensing.rest.impl.RootResourceAccessImpl;

public class ThingsAccessImpl
implements ThingsAccess {
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;
    @Context
    Application application;

    private SensiNactSession getSession() {
        return (SensiNactSession)this.providers.getContextResolver(SensiNactSession.class, MediaType.WILDCARD_TYPE).getContext(null);
    }

    private ObjectMapper getMapper() {
        return (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(null);
    }

    public Thing getThing(String id) {
        DtoMapper.validatedProviderId(id);
        return DtoMapper.toThing(this.getSession(), this.uriInfo, id);
    }

    public ResultList<Datastream> getThingDatastreams(String id) {
        DtoMapper.validatedProviderId(id);
        SensiNactSession userSession = this.getSession();
        ProviderDescription providerDescription = userSession.describeProvider(id);
        if (providerDescription == null) {
            throw new NotFoundException("Unknown provider");
        }
        ResultList list = new ResultList();
        list.value = providerDescription.services.stream().map(s -> userSession.describeService(id, s)).flatMap(s -> s.resources.stream().map(r -> userSession.describeResource(s.provider, s.service, r))).map(r -> DtoMapper.toDatastream(userSession, this.getMapper(), this.uriInfo, r)).collect(Collectors.toList());
        return list;
    }

    public Datastream getThingDatastream(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        SensiNactSession userSession = this.getSession();
        String service = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + service.length() + 2));
        Datastream d = DtoMapper.toDatastream(userSession, this.getMapper(), this.uriInfo, userSession.describeResource(provider, service, resource));
        if (!id2.equals(d.id)) {
            throw new NotFoundException();
        }
        return d;
    }

    @PaginationLimit(value=500)
    public ResultList<Observation> getThingDatastreamObservations(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        SensiNactSession userSession = this.getSession();
        String service = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + service.length() + 2));
        return RootResourceAccessImpl.getObservationList(userSession, this.uriInfo, this.application, provider, service, resource);
    }

    public ObservedProperty getThingDatastreamObservedProperty(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        SensiNactSession userSession = this.getSession();
        String service = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + service.length() + 2));
        ObservedProperty o = DtoMapper.toObservedProperty(this.uriInfo, userSession.describeResource(provider, service, resource));
        if (!id2.equals(o.id)) {
            throw new NotFoundException();
        }
        return o;
    }

    public Sensor getThingDatastreamSensor(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        SensiNactSession userSession = this.getSession();
        String service = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + 1));
        String resource = DtoMapper.extractFirstIdSegment(id2.substring(provider.length() + service.length() + 2));
        Sensor s = DtoMapper.toSensor(this.uriInfo, userSession.describeResource(provider, service, resource));
        if (!id2.equals(s.id)) {
            throw new NotFoundException();
        }
        return s;
    }

    public Thing getThingDatastreamThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        return this.getThing(id);
    }

    public ResultList<HistoricalLocation> getThingHistoricalLocations(String id) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.getMapper(), this.uriInfo, provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }

    public HistoricalLocation getThingHistoricalLocation(String id, String id2) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        DtoMapper.getTimestampFromId(id2);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.getMapper(), this.uriInfo, provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        return hl;
    }

    public Thing getThingHistoricalLocationsThing(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        return this.getThing(id);
    }

    public ResultList<Location> getThingHistoricalLocationLocations(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        DtoMapper.getTimestampFromId(id2);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toLocation(this.getSession(), this.uriInfo, this.getMapper(), provider));
        return list;
    }

    public ResultList<Location> getThingLocations(String id) {
        String provider = DtoMapper.extractFirstIdSegment(id);
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toLocation(this.getSession(), this.uriInfo, this.getMapper(), provider));
        return list;
    }

    public Location getThingLocation(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        DtoMapper.getTimestampFromId(id2);
        Location l = DtoMapper.toLocation(this.getSession(), this.uriInfo, this.getMapper(), provider);
        if (!id2.equals(l.id)) {
            throw new NotFoundException();
        }
        return l;
    }

    public ResultList<Thing> getThingLocationThings(String id, String id2) {
        String provider = DtoMapper.extractFirstIdSegment(id2);
        if (!id.equals(provider)) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(DtoMapper.toThing(this.getSession(), this.uriInfo, provider));
        return list;
    }

    public ResultList<HistoricalLocation> getThingLocationHistoricalLocations(String id, String id2) {
        HistoricalLocation hl;
        String provider = DtoMapper.extractFirstIdSegment(id2);
        try {
            hl = DtoMapper.toHistoricalLocation(this.getSession(), this.getMapper(), this.uriInfo, provider);
        }
        catch (IllegalArgumentException iae) {
            throw new NotFoundException();
        }
        ResultList list = new ResultList();
        list.value = List.of(hl);
        return list;
    }
}

