/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.model.nexus;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sensinact.core.command.impl.ActionHandler;
import org.eclipse.sensinact.core.command.impl.ResourcePullHandler;
import org.eclipse.sensinact.core.command.impl.ResourcePushHandler;
import org.eclipse.sensinact.core.model.ResourceType;
import org.eclipse.sensinact.core.model.nexus.emf.EMFUtil;
import org.eclipse.sensinact.core.model.nexus.emf.NamingUtils;
import org.eclipse.sensinact.core.model.nexus.emf.compare.EMFCompareUtil;
import org.eclipse.sensinact.core.notification.NotificationAccumulator;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.core.twin.impl.TimedValueImpl;
import org.eclipse.sensinact.core.whiteboard.impl.SensinactWhiteboard;
import org.eclipse.sensinact.model.core.metadata.ActionParameter;
import org.eclipse.sensinact.model.core.metadata.AnnotationMetadata;
import org.eclipse.sensinact.model.core.metadata.MetadataFactory;
import org.eclipse.sensinact.model.core.metadata.NexusMetadata;
import org.eclipse.sensinact.model.core.metadata.ResourceAttribute;
import org.eclipse.sensinact.model.core.metadata.ResourceMetadata;
import org.eclipse.sensinact.model.core.metadata.ServiceReference;
import org.eclipse.sensinact.model.core.provider.Admin;
import org.eclipse.sensinact.model.core.provider.DynamicProvider;
import org.eclipse.sensinact.model.core.provider.FeatureCustomMetadata;
import org.eclipse.sensinact.model.core.provider.Metadata;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.eclipse.sensinact.model.core.provider.ProviderFactory;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.eclipse.sensinact.model.core.provider.Service;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelNexus {
    private static final Logger LOG = LoggerFactory.getLogger(ModelNexus.class);
    private static final String BASE = "data/";
    private static final String BASIC_EPACKAGES = "data/ePackages.ecore";
    private static final String BASIC_PROVIDERS = "data/providers.xmi";
    private final ResourceSet resourceSet;
    private final ProviderPackage providerPackage;
    private final Supplier<NotificationAccumulator> notificationAccumulator;
    private final Map<String, Provider> providers = new HashMap<String, Provider>();
    private final SensinactWhiteboard whiteboard;

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator) {
        this(resourceSet, ProviderPackage2, accumulator, (SensinactWhiteboard)null);
    }

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator, ActionHandler actionHandler) {
        this(resourceSet, ProviderPackage2, accumulator, actionHandler, null, null);
    }

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator, final ActionHandler actionHandler, final ResourcePullHandler resourceValuePullHandler, final ResourcePushHandler resourceValuePushHandler) {
        this(resourceSet, ProviderPackage2, accumulator, new SensinactWhiteboard(null, null){

            @Override
            public Promise<Object> act(String modelPackageUri, String model, String provider, String service, String resource, Map<String, Object> arguments) {
                if (actionHandler != null) {
                    return actionHandler.act(modelPackageUri, model, provider, service, resource, arguments);
                }
                throw new RuntimeException("No action handler set");
            }

            @Override
            public <T> Promise<TimedValue<T>> pullValue(String modelPackageUri, String model, String provider, String service, String resource, Class<T> type, TimedValue<T> cachedValue, Consumer<TimedValue<T>> gatewayUpdate) {
                if (resourceValuePullHandler != null) {
                    return resourceValuePullHandler.pullValue(modelPackageUri, model, provider, service, resource, type, cachedValue, gatewayUpdate);
                }
                throw new RuntimeException("No pullValue handler set");
            }

            @Override
            public <T> Promise<TimedValue<T>> pushValue(String modelPackageUri, String model, String provider, String service, String resource, Class<T> type, TimedValue<T> cachedValue, TimedValue<T> newValue, Consumer<TimedValue<T>> gatewayUpdate) {
                if (resourceValuePushHandler != null) {
                    return resourceValuePushHandler.pushValue(modelPackageUri, model, provider, service, resource, type, cachedValue, newValue, gatewayUpdate);
                }
                throw new RuntimeException("No pushValue handler set");
            }
        });
    }

    public ModelNexus(ResourceSet resourceSet, ProviderPackage ProviderPackage2, Supplier<NotificationAccumulator> accumulator, SensinactWhiteboard whiteboard) {
        this.resourceSet = resourceSet;
        this.providerPackage = ProviderPackage2;
        this.notificationAccumulator = accumulator;
        this.whiteboard = whiteboard;
        this.loadEPackages(Paths.get(BASIC_EPACKAGES, new String[0]));
        if (!resourceSet.getPackageRegistry().containsKey((Object)"https://eclipse.org/sensinact/default")) {
            EMFUtil.createPackage("base", "https://eclipse.org/sensinact/default", "sensinactBase", this.resourceSet);
        }
        this.loadInstances(Paths.get(BASIC_PROVIDERS, new String[0]));
        this.setupSensinactProvider();
    }

    private void loadEPackages(Path fileName) {
        if (Files.isRegularFile(fileName, new LinkOption[0])) {
            Resource resource = this.resourceSet.createResource(URI.createFileURI((String)fileName.toString()));
            try {
                resource.load(null);
                if (!resource.getContents().isEmpty()) {
                    resource.getContents().forEach(e -> {
                        EPackage ePackage = (EPackage)e;
                        resource.setURI(URI.createURI((String)ePackage.getNsURI()));
                        EcoreUtil.resolveAll((EObject)ePackage);
                        this.resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
                    });
                    this.resourceSet.getResources().remove((Object)resource);
                }
            }
            catch (IOException e2) {
                LOG.error("THIS WILL BE A RUNTIME EXCPETION FOR NOW: Error Loading default EPackage from persistent file: {}", (Object)fileName, (Object)e2);
                throw new RuntimeException(e2);
            }
        }
    }

    private void loadInstances(Path fileName) {
        if (Files.isRegularFile(fileName, new LinkOption[0])) {
            try {
                URI uri = URI.createFileURI((String)fileName.toString());
                Resource resource = this.resourceSet.createResource(uri);
                resource.load(null);
                if (!resource.getContents().isEmpty()) {
                    resource.getContents().forEach(e -> {
                        Provider provider = (Provider)e;
                        EClass eClass = provider.eClass();
                        this.registerModel(eClass, Instant.ofEpochMilli(resource.getTimeStamp()), true);
                        this.providers.put(provider.getId(), provider);
                    });
                }
                resource.getContents().clear();
                this.resourceSet.getResources().remove((Object)resource);
            }
            catch (IOException e2) {
                LOG.error("THIS WILL BE A RUNTIME EXCPETION FOR NOW: Error loading provider from Path: {}", (Object)fileName, (Object)e2);
                throw new RuntimeException(e2);
            }
        }
    }

    private void setupSensinactProvider() {
        if (!this.providers.containsKey("sensinact")) {
            Instant now = Instant.now();
            EClass sensiNactModel = this.getModel("https://eclipse.org/sensinact/default", "sensinact").orElseGet(() -> this.createModel("https://eclipse.org/sensinact/default", "sensinact", now));
            EReference svc = Optional.ofNullable(this.getServiceForModel(sensiNactModel, "system")).orElseGet(() -> this.createService(sensiNactModel, "system", now));
            EClass svcClass = svc.getEReferenceType();
            EStructuralFeature versionResource = Optional.ofNullable(svcClass.getEStructuralFeature("version")).orElseGet(() -> this.createResource(svcClass, "version", Double.TYPE, now, null));
            EStructuralFeature startedResource = Optional.ofNullable(svcClass.getEStructuralFeature("started")).orElseGet(() -> this.createResource(svcClass, "started", Instant.class, now, null));
            Provider provider = Optional.ofNullable(this.getProvider("sensiNact")).orElseGet(() -> this.doCreateProvider(sensiNactModel, "sensiNact", now));
            this.handleDataUpdate(provider, (EStructuralFeature)svc, versionResource, (Object)0.1, now);
            this.handleDataUpdate(provider, (EStructuralFeature)svc, startedResource, (Object)now, now);
        }
    }

    public void shutDown() {
        Resource providers = this.resourceSet.createResource(URI.createURI((String)BASIC_PROVIDERS));
        this.providers.values().forEach(arg_0 -> providers.getContents().add(arg_0));
        try {
            providers.save(Collections.emptyMap());
        }
        catch (IOException e2) {
            LOG.error("Could not save provider instances", (Throwable)e2);
        }
        Resource ePackages = this.resourceSet.createResource(URI.createURI((String)BASIC_EPACKAGES));
        this.resourceSet.getPackageRegistry().entrySet().stream().filter(e -> !EPackage.Registry.INSTANCE.containsKey(e.getKey())).map(Map.Entry::getValue).map(EPackage.class::cast).forEach(arg_0 -> ePackages.getContents().add(arg_0));
        try {
            ePackages.save(Collections.emptyMap());
        }
        catch (IOException e3) {
            LOG.error("Could not save EPackages", (Throwable)e3);
        }
        this.resourceSet.getResources().clear();
    }

    public void linkProviders(String parentProvider, String childProvider, Instant timestamp) {
        Instant metaTimestamp = timestamp == null ? Instant.now() : timestamp;
        NotificationAccumulator accumulator = this.notificationAccumulator.get();
        Provider parent = this.providers.get(parentProvider);
        Provider child = this.providers.get(childProvider);
        if (parent == null) {
            throw new IllegalArgumentException("No parent provider " + parentProvider);
        }
        if (child == null) {
            throw new IllegalArgumentException("No child provider " + childProvider);
        }
        parent.getLinkedProviders().add((Object)child);
    }

    public void unlinkProviders(String parentProvider, String childProvider, Instant timestamp) {
        Instant metaTimestamp = timestamp == null ? Instant.now() : timestamp;
        Provider parent = this.providers.get(parentProvider);
        Provider child = this.providers.get(childProvider);
        if (parent == null) {
            throw new IllegalArgumentException("No parent provider " + parentProvider);
        }
        if (child == null) {
            throw new IllegalArgumentException("No child provider " + childProvider);
        }
        parent.getLinkedProviders().remove((Object)child);
    }

    public void handleDataUpdate(Provider provider, String serviceName, EStructuralFeature resourceFeature, Object data, Instant timestamp) {
        Service service = provider.getService(serviceName);
        if (service == null) {
            Optional<EReference> serviceFeature = this.getServiceReferencesForModel(provider.eClass()).filter(ref -> serviceName.equals(ref.getName())).findFirst();
            if (serviceFeature.isEmpty()) {
                throw new IllegalArgumentException("No Service with name " + serviceName + " exists for provider " + provider.getId() + " of model " + EMFUtil.getModelName(provider.eClass()));
            }
            this.handleDataUpdate(provider, (EStructuralFeature)serviceFeature.get(), resourceFeature, data, timestamp);
            return;
        }
        String providerName = provider.getId();
        String modelName = EMFUtil.getModelName(provider.eClass());
        NotificationAccumulator accumulator = this.notificationAccumulator.get();
        String packageUri = provider.eClass().getEPackage().getNsURI();
        this.handleDataUpdate(provider, serviceName, service, resourceFeature, data, timestamp, accumulator, packageUri, modelName, providerName);
    }

    public void handleDataUpdate(Provider provider, EStructuralFeature serviceFeature, EStructuralFeature resourceFeature, Object data, Instant timestamp) {
        String providerName = provider.getId();
        String modelName = EMFUtil.getModelName(provider.eClass());
        NotificationAccumulator accumulator = this.notificationAccumulator.get();
        String packageUri = provider.eClass().getEPackage().getNsURI();
        Service service = (Service)provider.eGet(serviceFeature);
        if (service == null) {
            service = (Service)EcoreUtil.create((EClass)((EClass)serviceFeature.getEType()));
            provider.eSet(serviceFeature, (Object)service);
            accumulator.addService(packageUri, modelName, providerName, serviceFeature.getName());
        }
        this.handleDataUpdate(provider, serviceFeature.getName(), service, resourceFeature, data, timestamp, accumulator, packageUri, modelName, providerName);
    }

    public void handleDataUpdate(DynamicProvider provider, String serviceName, EStructuralFeature resourceFeature, Object data, Instant timestamp) {
        Service service = (Service)provider.getServices().get((Object)serviceName);
        if (service == null) {
            throw new UnsupportedOperationException("No service with the name " + serviceName + " exists. This Method is only inteded to be used with already existing Services");
        }
        String providerName = provider.getId();
        String modelName = EMFUtil.getModelName(provider.eClass());
        NotificationAccumulator accumulator = this.notificationAccumulator.get();
        String packageUri = provider.eClass().getEPackage().getNsURI();
        this.handleDataUpdate((Provider)provider, serviceName, service, resourceFeature, data, timestamp, accumulator, packageUri, modelName, providerName);
    }

    private void handleDataUpdate(Provider provider, String serviceName, Service service, EStructuralFeature resourceFeature, Object data, Instant timestamp, NotificationAccumulator accumulator, String packageUri, String modelName, String providerName) {
        EClassifier resourceType;
        Instant metaTimestamp = timestamp == null ? Instant.now() : timestamp;
        ResourceMetadata metadata = (ResourceMetadata)service.getMetadata().get((Object)resourceFeature);
        Map<String, Object> oldMetaData = null;
        Object oldValue = service.eGet(resourceFeature);
        if (metadata != null) {
            oldMetaData = EMFCompareUtil.extractMetadataMap(oldValue, (Metadata)metadata, (ETypedElement)resourceFeature);
        }
        if (oldValue == null) {
            accumulator.addResource(packageUri, modelName, providerName, serviceName, resourceFeature.getName());
        }
        if (metadata == null || !metadata.getTimestamp().isAfter(timestamp.plusMillis(1L))) {
            resourceType = resourceFeature.getEType();
            if (metadata == null) {
                metadata = MetadataFactory.eINSTANCE.createResourceMetadata();
                service.getMetadata().put((Object)resourceFeature, (Object)metadata);
            }
            metadata.setTimestamp(metaTimestamp);
            if (data == null || resourceType.isInstance(data)) {
                service.eSet(resourceFeature, data);
            } else {
                service.eSet(resourceFeature, EMFUtil.convertToTargetType(resourceType, data));
            }
        } else {
            return;
        }
        accumulator.resourceValueUpdate(packageUri, modelName, providerName, serviceName, resourceFeature.getName(), resourceType.getInstanceClass(), oldValue, data, timestamp);
        metadata.setTimestamp(timestamp);
        Map<String, Object> newMetaData = EMFCompareUtil.extractMetadataMap(data, (Metadata)metadata, (ETypedElement)resourceFeature);
        accumulator.metadataValueUpdate(packageUri, modelName, providerName, serviceName, resourceFeature.getName(), oldMetaData, newMetaData, timestamp);
    }

    private Provider doCreateProvider(EClass model, String providerName, Instant timestamp) {
        return this.doCreateProvider(model, providerName, timestamp, true);
    }

    private Provider doCreateProvider(EClass model, String providerName, Instant timestamp, boolean createAdmin) {
        Provider provider = (Provider)EcoreUtil.create((EClass)model);
        provider.setId(providerName);
        this.notificationAccumulator.get().addProvider(model.getEPackage().getNsURI(), EMFUtil.getModelName(model), providerName);
        if (createAdmin) {
            this.createAdminServiceForProvider(provider, timestamp);
        }
        this.providers.put(providerName, provider);
        return provider;
    }

    private void createAdminServiceForProvider(Provider original, Instant timestamp) {
        Provider provider = (Provider)EcoreUtil.copy((EObject)original);
        Admin adminSvc = ProviderFactory.eINSTANCE.createAdmin();
        provider.setAdmin(adminSvc);
        for (EStructuralFeature resourceFeature : provider.getAdmin().eClass().getEStructuralFeatures()) {
            if (resourceFeature != ProviderPackage.Literals.ADMIN__FRIENDLY_NAME && resourceFeature != ProviderPackage.Literals.ADMIN__MODEL_PACKAGE_URI && resourceFeature != ProviderPackage.Literals.ADMIN__MODEL) continue;
            ResourceMetadata metadata = MetadataFactory.eINSTANCE.createResourceMetadata();
            metadata.setOriginalName(resourceFeature.getName());
            metadata.setTimestamp(timestamp);
            adminSvc.getMetadata().put((Object)resourceFeature, (Object)metadata);
        }
        adminSvc.setFriendlyName(provider.getId());
        adminSvc.setModelPackageUri(provider.eClass().getEPackage().getNsURI());
        adminSvc.setModel(EMFUtil.getModelName(provider.eClass()));
        EMFCompareUtil.compareAndSet(provider, original, this.notificationAccumulator.get());
    }

    public Provider createProviderInstance(String modelName, String providerName) {
        return this.createProviderInstance(EMFUtil.constructPackageUri(modelName), modelName, providerName, Instant.now());
    }

    public Provider createProviderInstance(String modelName, String providerName, Instant timestamp) {
        return this.createProviderInstance(EMFUtil.constructPackageUri(modelName), modelName, providerName, timestamp);
    }

    public Provider createProviderInstance(String modelPackageUri, String modelName, String providerName) {
        return this.createProviderInstance(modelPackageUri, modelName, providerName, Instant.now());
    }

    public Provider createProviderInstance(String modelPackageUri, String modelName, String providerName, Instant timestamp) {
        Provider provider = this.getProvider(providerName);
        if (provider != null) {
            String m = EMFUtil.getModelName(provider.eClass());
            if (!m.equals(modelName)) {
                throw new IllegalArgumentException("The provider " + providerName + " already exists with a different model " + m);
            }
            throw new IllegalArgumentException("The provider " + providerName + " already exists with the model " + modelName);
        }
        provider = this.doCreateProvider(this.getMandatoryModel(modelPackageUri, modelName), providerName, timestamp);
        return provider;
    }

    public Provider getProvider(String providerName) {
        return this.providers.get(providerName);
    }

    public String getProviderModel(String providerName) {
        return Optional.ofNullable(this.providers.get(providerName)).map(p -> EMFUtil.getModelName(p.eClass())).orElse(null);
    }

    public String getProviderPackageUri(String providerName) {
        return Optional.ofNullable(this.providers.get(providerName)).map(p -> p.eClass().getEPackage().getNsURI()).orElse(null);
    }

    public Provider getProvider(String modelPackageUri, String model, String providerName) {
        Provider p = this.providers.get(providerName);
        if (p != null) {
            String mp;
            String m = EMFUtil.getModelName(p.eClass());
            String string = mp = modelPackageUri == null ? EMFUtil.constructPackageUri(model) : modelPackageUri;
            if (!m.equals(model) || !p.eClass().getEPackage().getNsURI().equals(mp)) {
                LOG.warn("Provider {} exists but with model {} or package {} not model {} of package {}", new Object[]{providerName, m, p.eClass().getEPackage().getNsURI(), model, mp});
                p = null;
            }
        }
        return p;
    }

    public Collection<Provider> getProviders() {
        return Collections.unmodifiableCollection(this.providers.values());
    }

    public List<Provider> getProviders(String modelPackageUri, String model) {
        EClass m = this.getMandatoryModel(modelPackageUri, model);
        return this.providers.values().stream().filter(p -> EMFUtil.getModelName(p.eClass()).equals(m)).collect(Collectors.toList());
    }

    public EAttribute createResource(EClass service, String resource, Class<?> type, Instant timestamp, Object defaultValue) {
        return this.createResource(service, resource, type, timestamp, defaultValue, false, 0L, false);
    }

    public EAttribute createResource(EClass service, String resource, Class<?> type, Instant timestamp, Object defaultValue, boolean hasGetter, long getterCacheMs, boolean hasSetter) {
        FeatureCustomMetadata resourceType = ProviderFactory.eINSTANCE.createFeatureCustomMetadata();
        resourceType.setName("resourceType");
        resourceType.setValue((Object)ResourceType.SENSOR);
        resourceType.setTimestamp(Instant.EPOCH);
        return this.doCreateResource(service, resource, type, timestamp, defaultValue, List.of(resourceType), hasGetter, getterCacheMs, hasSetter);
    }

    private EAttribute doCreateResource(EClass service, String resource, Class<?> type, Instant timestamp, Object defaultValue, List<FeatureCustomMetadata> metadata, boolean hasGetter, long getterCacheMs, boolean hasSetter) {
        this.assertResourceNotExist(service, resource);
        ResourceAttribute feature = EMFUtil.createResourceAttribute(service, resource, type, defaultValue);
        feature.setExternalGet(hasGetter);
        feature.setExternalSet(hasSetter);
        if (getterCacheMs > 0L) {
            feature.setExternalGetCacheMs(getterCacheMs);
        }
        EMFUtil.fillMetadata((NexusMetadata)feature, timestamp, false, resource, List.of());
        return feature;
    }

    private void assertResourceNotExist(EClass service, String resource) {
        ETypedElement element = service.getEOperations().stream().filter(o -> o.getName().equals(resource)).map(ETypedElement.class::cast).findFirst().orElseGet(() -> service.getEStructuralFeature(resource));
        if (element != null) {
            throw new IllegalArgumentException("There is an existing resource with name " + resource + " in service " + service + " in model " + EMFUtil.getModelName(service.eContainingFeature().getEContainingClass()));
        }
    }

    public EClass createModel(String modelName, Instant timestamp) {
        return this.createModel(EMFUtil.constructPackageUri(modelName), modelName, timestamp);
    }

    public EClass createModel(String theModelPackageUri, String modelName, Instant timestamp) {
        if (theModelPackageUri == null || theModelPackageUri.isBlank()) {
            return this.createModel(modelName, timestamp);
        }
        if (this.getModel(theModelPackageUri, modelName).isPresent()) {
            throw new IllegalArgumentException("There is an existing model with name " + modelName);
        }
        String modelClassName = NamingUtils.sanitizeName(modelName, false);
        EPackage ePackage = this.resourceSet.getPackageRegistry().getEPackage(theModelPackageUri);
        if (ePackage == null) {
            ePackage = EMFUtil.createPackage(modelName, theModelPackageUri, modelName, this.resourceSet);
        }
        EClass model = EMFUtil.createEClass(modelClassName, ePackage, ec -> this.createEClassAnnotations(modelName, timestamp), ProviderPackage.Literals.PROVIDER);
        return model;
    }

    private EReference doCreateService(EClass model, String name, Instant timestamp) {
        EPackage ePackage = model.getEPackage();
        EClass service = EMFUtil.createEClass(NamingUtils.sanitizeName(name, false), ePackage, ec -> this.createEClassAnnotations(timestamp), ProviderPackage.Literals.SERVICE);
        ServiceReference ref = EMFUtil.createServiceReference(model, name, service, true);
        EMFUtil.fillMetadata((NexusMetadata)ref, timestamp, false, name, List.of());
        return ref;
    }

    private List<EAnnotation> createEClassAnnotations(Instant timestamp) {
        AnnotationMetadata meta = MetadataFactory.eINSTANCE.createAnnotationMetadata();
        meta.setTimestamp(timestamp);
        EAnnotation annotation = EMFUtil.createEAnnotation("metadata", Collections.singletonList(meta));
        return Collections.singletonList(annotation);
    }

    private List<EAnnotation> createEClassAnnotations(String model, Instant timestamp) {
        return List.of(this.createEClassAnnotations(timestamp).get(0), EMFUtil.createEAnnotation("model", Map.of("name", model)));
    }

    public Map<String, Object> getResourceMetadata(Service svc, ETypedElement rcFeature) {
        if (svc == null) {
            return Map.of();
        }
        ResourceMetadata metadata = (ResourceMetadata)svc.getMetadata().get((Object)rcFeature);
        if (metadata == null) {
            return Map.of();
        }
        return this.toMetadataMap(rcFeature, metadata);
    }

    public Map<String, Object> getResourceMetadata(Provider provider, String serviceName, ETypedElement rcFeature) {
        Service svc = provider.getService(serviceName);
        return this.getResourceMetadata(svc, rcFeature);
    }

    private Map<String, Object> toMetadataMap(ETypedElement rcFeature, ResourceMetadata metadata) {
        HashMap<String, Object> rcMeta = new HashMap<String, Object>();
        rcMeta.putAll(EMFUtil.toMetadataAttributesToMap((Metadata)metadata, rcFeature));
        return rcMeta;
    }

    public TimedValue<Object> getResourceMetadataValue(Provider provider, String serviceName, ETypedElement rcFeature, String key) {
        Service svc = provider.getService(serviceName);
        if (svc == null) {
            return null;
        }
        ResourceMetadata metadata = (ResourceMetadata)svc.getMetadata().get((Object)rcFeature);
        if (metadata != null) {
            for (FeatureCustomMetadata entry : metadata.getExtra()) {
                if (!entry.getName().equals(key)) continue;
                return new TimedValueImpl<Object>(entry.getValue(), entry.getTimestamp());
            }
        }
        return null;
    }

    public void setResourceMetadata(Provider provider, EStructuralFeature svcFeature, ETypedElement resource, String metadataKey, Object value, Instant timestamp) {
        Service svc = (Service)provider.eGet(svcFeature);
        this.setResourceMetadata(provider, svcFeature.getName(), svc, resource, metadataKey, value, timestamp);
    }

    public void setResourceMetadata(Provider provider, String serviceName, ETypedElement resource, String metadataKey, Object value, Instant timestamp) {
        Service svc;
        EStructuralFeature feature = provider.eClass().getEStructuralFeature(serviceName);
        if (feature != null) {
            this.setResourceMetadata(provider, feature, resource, metadataKey, value, timestamp);
            return;
        }
        if (provider instanceof DynamicProvider && (svc = (Service)((DynamicProvider)provider).getServices().get((Object)serviceName)) != null) {
            this.setResourceMetadata(provider, serviceName, svc, resource, metadataKey, value, timestamp);
        }
    }

    public void setResourceMetadata(Provider provider, String serviceName, Service svc, ETypedElement resource, String metadataKey, Object value, Instant timestamp) {
        ResourceMetadata metadata;
        if (svc == null) {
            throw new IllegalArgumentException("Service must not be null");
        }
        if (metadataKey == null || metadataKey.isEmpty()) {
            throw new IllegalArgumentException("Empty metadata key");
        }
        if (timestamp == null) {
            throw new IllegalArgumentException("Invalid timestamp");
        }
        ResourceMetadata resourceMetadata = metadata = svc == null ? null : (ResourceMetadata)svc.getMetadata().get((Object)resource);
        if (metadata == null) {
            throw new IllegalStateException("No existing metadata for resource");
        }
        Map<String, Object> oldMetadata = this.toMetadataMap(resource, metadata);
        metadata.setTimestamp(timestamp);
        metadata.getExtra().stream().filter(fcm -> fcm.getName().equals(metadataKey)).findFirst().ifPresentOrElse(fcm -> this.handleFeatureCustomMetadata((FeatureCustomMetadata)fcm, metadataKey, timestamp, value), () -> metadata.getExtra().add((Object)this.handleFeatureCustomMetadata(ProviderFactory.eINSTANCE.createFeatureCustomMetadata(), metadataKey, timestamp, value)));
        Map<String, Object> newMetadata = this.toMetadataMap(resource, metadata);
        this.notificationAccumulator.get().metadataValueUpdate(provider.eClass().getEPackage().getNsURI(), EMFUtil.getModelName(provider.eClass()), provider.getId(), serviceName, resource.getName(), oldMetadata, newMetadata, timestamp);
    }

    private FeatureCustomMetadata handleFeatureCustomMetadata(FeatureCustomMetadata customMetadata, String metadataKey, Instant timestamp, Object value) {
        customMetadata.setName(metadataKey);
        customMetadata.setTimestamp(timestamp);
        customMetadata.setValue(value);
        return customMetadata;
    }

    public Set<String> getModelNames() {
        throw new UnsupportedOperationException("Not implemented yet1");
    }

    public Set<String> getModelNames(String modelPackageUri) {
        EPackage ePackage = this.resourceSet.getPackageRegistry().getEPackage(modelPackageUri);
        return this.getModelNames(ePackage);
    }

    public Set<String> getModelNames(EPackage ePackage) {
        return this.getProviderEClassesFromEPackage(ePackage).map(EMFUtil::getModelName).collect(Collectors.toSet());
    }

    public Optional<EClass> getModel(String modelPackageUri, String modelName) {
        EPackage ePackage;
        String themodelPackageUri = modelPackageUri;
        if (themodelPackageUri == null || modelPackageUri.isBlank()) {
            themodelPackageUri = EMFUtil.constructPackageUri(modelName);
        }
        if ((ePackage = this.resourceSet.getPackageRegistry().getEPackage(themodelPackageUri)) == null) {
            return Optional.empty();
        }
        EClass result = (EClass)ePackage.getEClassifier(modelName);
        if (result != null) {
            return Optional.of(result);
        }
        return ePackage.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(ec -> EMFUtil.getModelName(ec).equals(modelName)).findFirst();
    }

    public boolean registered(EClass eClass) {
        EPackage ePackage = eClass.getEPackage();
        return this.resourceSet.getPackageRegistry().getEPackage(ePackage.getNsURI()) != null;
    }

    private EClass getMandatoryModel(String modelPackageUri, String modelName) {
        return this.getModel(modelPackageUri, modelName).orElseThrow(() -> new IllegalArgumentException("No model with name " + modelName));
    }

    public EReference createService(EClass model, String service, Instant creationTimestamp) {
        if (model.getEStructuralFeature(service) != null) {
            throw new IllegalArgumentException("There is an existing service with name " + service + " in model " + model);
        }
        return this.doCreateService(model, service, creationTimestamp);
    }

    public Stream<EReference> getServiceReferencesForModel(EClass model) {
        EClass svcClass = ProviderPackage.Literals.SERVICE;
        return model.getEAllReferences().stream().filter(r -> svcClass.isSuperTypeOf(r.getEReferenceType()));
    }

    public Map<String, EClass> getDefinedServiceForProvider(Provider provider) {
        LinkedHashMap result = new LinkedHashMap();
        this.getServiceReferencesForModel(provider.eClass()).forEach(feature -> result.put(feature.getName(), feature.getEReferenceType()));
        if (provider instanceof DynamicProvider) {
            ((DynamicProvider)provider).getServices().forEach(e -> result.put((String)e.getKey(), ((Service)e.getValue()).eClass()));
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Service> getServiceInstancesForProvider(Provider provider) {
        LinkedHashMap result = new LinkedHashMap();
        this.getServiceReferencesForModel(provider.eClass()).filter(arg_0 -> ((Provider)provider).eIsSet(arg_0)).forEach(feature -> result.put(feature.getName(), (Service)provider.eGet((EStructuralFeature)feature)));
        if (provider instanceof DynamicProvider) {
            ((DynamicProvider)provider).getServices().forEach(e -> result.put((String)e.getKey(), (Service)e.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    private EReference getServiceForModel(EClass model, String serviceName) {
        EStructuralFeature feature = model.getEStructuralFeature(serviceName);
        EClass serviceEClass = ProviderPackage.Literals.SERVICE;
        if (!(feature == null || feature instanceof EReference && serviceEClass.isSuperTypeOf(((EReference)feature).getEReferenceType()))) {
            throw new IllegalArgumentException("The field " + serviceName + " exists in the model " + EMFUtil.getModelName(model) + " and is not a service");
        }
        return feature == null ? null : (EReference)feature;
    }

    public Stream<ETypedElement> getResourcesForService(EClass svcClass) {
        return Stream.concat(svcClass.getEAllAttributes().stream().filter(o -> o.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE), svcClass.getEAllOperations().stream().filter(o -> o.getEContainingClass().getEPackage() != EcorePackage.eINSTANCE).filter(Predicate.not(ProviderPackage.Literals.SERVICE___EIS_SET__ESTRUCTURALFEATURE::equals)));
    }

    public EOperation createActionResource(EClass serviceEClass, String name, Class<?> type, List<Map.Entry<String, Class<?>>> namedParameterTypes) {
        this.assertResourceNotExist(serviceEClass, name);
        List<ActionParameter> params = namedParameterTypes.stream().map(EMFUtil::createActionParameter).collect(Collectors.toList());
        return EMFUtil.createAction(serviceEClass, name, type, params);
    }

    public Promise<Object> act(Provider provider, EStructuralFeature service, ETypedElement resource, Map<String, Object> parameters) {
        return this.act(provider, service.getName(), resource, parameters);
    }

    public Promise<Object> act(Provider provider, String service, ETypedElement resource, Map<String, Object> parameters) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to act on a value without an action handler"));
        }
        try {
            return this.whiteboard.act(provider.eClass().getEPackage().getNsURI(), EMFUtil.getModelName(provider.eClass()), provider.getId(), service, resource.getName(), parameters);
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public <T> Promise<TimedValue<T>> pullValue(Provider provider, String serviceName, ETypedElement resource, Class<T> valueType, TimedValue<T> cachedValue) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to pull a value without a pull handler"));
        }
        try {
            String modelName = EMFUtil.getModelName(provider.eClass());
            return this.whiteboard.pullValue(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), serviceName, resource.getName(), valueType, cachedValue, tv -> {
                if (tv != null) {
                    this.handleDataUpdate(provider, serviceName, (EStructuralFeature)resource, tv.getValue(), tv.getTimestamp());
                }
            });
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public <T> Promise<TimedValue<T>> pullValue(Provider provider, EStructuralFeature service, ETypedElement resource, Class<T> valueType, TimedValue<T> cachedValue) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to pull a value without a pull handler"));
        }
        try {
            String modelName = EMFUtil.getModelName(provider.eClass());
            return this.whiteboard.pullValue(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), service.getName(), resource.getName(), valueType, cachedValue, tv -> {
                if (tv != null) {
                    this.handleDataUpdate(provider, service, (EStructuralFeature)resource, tv.getValue(), tv.getTimestamp());
                }
            });
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public <T> Promise<TimedValue<T>> pushValue(Provider provider, String serviceName, ETypedElement resource, Class<T> valueType, TimedValue<T> cachedValue, TimedValue<T> newValue) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to push a value without a push handler"));
        }
        try {
            String modelName = EMFUtil.getModelName(provider.eClass());
            return this.whiteboard.pushValue(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), serviceName, resource.getName(), valueType, cachedValue, newValue, tv -> {
                if (tv != null) {
                    this.handleDataUpdate(provider, serviceName, (EStructuralFeature)resource, tv.getValue(), tv.getTimestamp());
                }
            });
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public <T> Promise<TimedValue<T>> pushValue(Provider provider, EStructuralFeature service, ETypedElement resource, Class<T> valueType, TimedValue<T> cachedValue, TimedValue<T> newValue) {
        if (this.whiteboard == null) {
            return Promises.failed((Throwable)new IllegalAccessError("Trying to push a value without a push handler"));
        }
        try {
            String modelName = EMFUtil.getModelName(provider.eClass());
            return this.whiteboard.pushValue(provider.eClass().getEPackage().getNsURI(), modelName, provider.getId(), service.getName(), resource.getName(), valueType, cachedValue, newValue, tv -> {
                if (tv != null) {
                    this.handleDataUpdate(provider, service, (EStructuralFeature)resource, tv.getValue(), tv.getTimestamp());
                }
            });
        }
        catch (Throwable t) {
            return Promises.failed((Throwable)t);
        }
    }

    public void deleteProvider(String packageUri, String model, String name) {
        String m = this.getProviderModel(name);
        String p = this.getProviderPackageUri(name);
        if (m != null) {
            if (m.equals(model) && p.equals(packageUri)) {
                this.doDeleteProvider(p, model, name);
            } else {
                LOG.warn("Unable to remove the provider {} with model {} of package as the actual model was {} of package {}", new Object[]{name, model, packageUri, m, p});
            }
        } else {
            LOG.info("The provider {} does not exist and cannot be removed", (Object)name);
        }
    }

    private void doDeleteProvider(String modelPackageUri, String model, String name) {
        this.providers.remove(name);
        this.notificationAccumulator.get().removeProvider(modelPackageUri, model, name);
    }

    public Provider save(Provider provider) {
        String id = this.validateAndGetName(provider);
        Provider original = this.providers.get(id);
        if (original == null) {
            original = this.doCreateProvider(provider.eClass(), id, Instant.now(), provider.getAdmin() == null);
        } else if (provider instanceof DynamicProvider && !(original instanceof DynamicProvider)) {
            DynamicProvider dynamicProvider = (DynamicProvider)EcoreUtil.create((EClass)provider.eClass());
            original.eClass().getEAllStructuralFeatures().forEach(e -> dynamicProvider.eSet(e, provider.eGet(e)));
            original = dynamicProvider;
            this.providers.put(id, (Provider)dynamicProvider);
        }
        EMFCompareUtil.compareAndSet(provider, original, this.notificationAccumulator.get());
        return (Provider)EcoreUtil.copy((EObject)original);
    }

    private String validateAndGetName(Provider provider) {
        String id = EMFUtil.getProviderName((EObject)provider);
        if (id == null || id.isBlank()) {
            throw new IllegalArgumentException(String.format("Missing name/id for provider %s", provider.toString()));
        }
        if (provider instanceof DynamicProvider) {
            EClass providerEClass = provider.eClass();
            List<String> duplicates = ((DynamicProvider)provider).getServices().keySet().stream().map(arg_0 -> ((EClass)providerEClass).getEStructuralFeature(arg_0)).filter(Objects::nonNull).filter(EReference.class::isInstance).map(EReference.class::cast).filter(ref -> ProviderPackage.Literals.SERVICE.isSuperTypeOf(ref.getEReferenceType())).map(ENamedElement::getName).collect(Collectors.toList());
            if (!duplicates.isEmpty()) {
                StringJoiner joiner = new StringJoiner(",");
                duplicates.forEach(joiner::add);
                throw new IllegalArgumentException(String.format("Provider %s has services in the service map with the same as a defined service reference: %s", id, joiner.toString()));
            }
        }
        return id;
    }

    public Provider getProvider(EClass model, String id) {
        Provider provider = this.providers.get(id);
        if (provider.eClass() != model) {
            throw new IllegalArgumentException("Provider " + id + " does not have the same model expected " + EMFUtil.getModelName(model) + ", but provider is " + EMFUtil.getModelName(provider.eClass()));
        }
        return provider;
    }

    public EClass registerModel(EClass modelEClass, Instant timestamp, boolean ignoreExisting) {
        if (!ignoreExisting && this.registered(modelEClass)) {
            throw new IllegalArgumentException("There is an existing model with name " + EMFUtil.getModelName(modelEClass));
        }
        EPackage ePackage = modelEClass.getEPackage();
        this.resourceSet.getPackageRegistry().putIfAbsent((Object)ePackage.getNsURI(), (Object)ePackage);
        return modelEClass;
    }

    public void addEPackage(EPackage ePackage) {
        if (ePackage != this.providerPackage) {
            this.getProviderEClassesFromEPackage(ePackage).filter(Predicate.not(this::registered)).forEach(ec -> this.registerModel((EClass)ec, Instant.now(), false));
        }
    }

    private Stream<EClass> getProviderEClassesFromEPackage(EPackage ePackage) {
        return ePackage.getEClassifiers().stream().filter(EClass.class::isInstance).map(EClass.class::cast).filter(arg_0 -> ((EClass)ProviderPackage.Literals.PROVIDER).isSuperTypeOf(arg_0));
    }

    private Stream<Provider> getProviderofEPackage(EPackage ePackage) {
        return this.providers.values().stream().filter(p -> p.eClass().getEPackage().equals(ePackage));
    }

    public void removeEPackage(EPackage ePackage) {
        if (ePackage != this.providerPackage) {
            this.getProviderofEPackage(ePackage).collect(Collectors.toSet()).forEach(p -> this.doDeleteProvider(ePackage.getNsURI(), EMFUtil.getModelName(p.eClass()), p.getId()));
        }
    }
}

