/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.twin.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.sensinact.core.command.impl.CommandScopedImpl;
import org.eclipse.sensinact.core.model.nexus.ModelNexus;
import org.eclipse.sensinact.core.twin.SensinactProvider;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.SensinactService;
import org.eclipse.sensinact.core.twin.impl.SensinactResourceImpl;
import org.eclipse.sensinact.model.core.provider.Provider;
import org.osgi.util.promise.PromiseFactory;

public class SensinactServiceImpl
extends CommandScopedImpl
implements SensinactService {
    private final SensinactProvider sensinactProvider;
    private final Provider provider;
    private final String serviceName;
    private final ModelNexus nexus;
    private final PromiseFactory promiseFactory;
    private EClass service;

    public SensinactServiceImpl(AtomicBoolean active, SensinactProvider sensinactProvider, Provider provider, String serviceName, EClass service, ModelNexus nexus, PromiseFactory promiseFactory) {
        super(active);
        this.sensinactProvider = sensinactProvider;
        this.provider = provider;
        this.serviceName = serviceName;
        this.service = service;
        this.nexus = nexus;
        this.promiseFactory = promiseFactory;
    }

    public Map<String, SensinactResource> getResources() {
        this.checkValid();
        return this.nexus.getResourcesForService(this.service).collect(Collectors.toMap(ENamedElement::getName, a -> new SensinactResourceImpl(this.active, this, this.provider, this.serviceName, (ETypedElement)a, a.getEType().getInstanceClass(), this.nexus, this.promiseFactory)));
    }

    public String getName() {
        this.checkValid();
        return this.serviceName;
    }

    public SensinactProvider getProvider() {
        this.checkValid();
        return this.sensinactProvider;
    }

    public String toString() {
        this.checkValid();
        return String.format("SensiNactService(provider=%s, name=%s, resources=%s)", this.provider.getId(), this.getName(), this.getResources().keySet());
    }
}

