/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.model.core.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public enum ValueType implements Enumerator
{
    FIXED(0, "FIXED", "FIXED"),
    OBSERVABLE(1, "OBSERVABLE", "OBSERVABLE"),
    MODIFIABLE(2, "MODIFIABLE", "MODIFIABLE");

    public static final int FIXED_VALUE = 0;
    public static final int OBSERVABLE_VALUE = 1;
    public static final int MODIFIABLE_VALUE = 2;
    private static final ValueType[] VALUES_ARRAY;
    public static final List<ValueType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ValueType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ValueType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ValueType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ValueType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ValueType get(int value) {
        switch (value) {
            case 0: {
                return FIXED;
            }
            case 1: {
                return OBSERVABLE;
            }
            case 2: {
                return MODIFIABLE;
            }
        }
        return null;
    }

    private ValueType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ValueType[]{FIXED, OBSERVABLE, MODIFIABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

