/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFDigitalTwin;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFProvider;
import org.eclipse.sensinact.core.model.Model;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.model.Service;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.push.DataUpdateException;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class SetValueCommand
extends AbstractSensinactCommand<Void> {
    private final DataUpdateDto dataUpdateDto;

    public SetValueCommand(DataUpdateDto dataUpdateDto) {
        this.dataUpdateDto = dataUpdateDto;
    }

    protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
        return this.doCall((SensinactEMFDigitalTwin)twin, modelMgr, promiseFactory).recoverWith(p -> promiseFactory.failed((Throwable)new DataUpdateException(this.dataUpdateDto.modelPackageUri, this.dataUpdateDto.model, this.dataUpdateDto.provider, this.dataUpdateDto.service, this.dataUpdateDto.resource, this.dataUpdateDto.originalDto, p.getFailure())));
    }

    private Promise<Void> doCall(SensinactEMFDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
        String packageUri;
        EClass modelEClass = this.dataUpdateDto.modelEClass;
        String string = packageUri = modelEClass == null ? this.dataUpdateDto.modelPackageUri : modelEClass.getEPackage().getNsURI();
        String mod = modelEClass != null ? modelEClass.getName() : (this.dataUpdateDto.model == null ? this.dataUpdateDto.provider : this.dataUpdateDto.model);
        String provider = this.dataUpdateDto.provider;
        EReference svcReference = this.dataUpdateDto.serviceReference;
        EClass svcEClass = svcReference != null ? svcReference.getEReferenceType() : this.dataUpdateDto.serviceEClass;
        String svc = svcReference != null ? svcReference.getName() : this.dataUpdateDto.service;
        String res = this.dataUpdateDto.resource;
        if (mod == null || provider == null || svc == null || res == null) {
            return promiseFactory.failed((Throwable)new NullPointerException("The provider, service and resource must be non null"));
        }
        SensinactResource resource = twin.getResource(packageUri, mod, provider, svc, res);
        if (resource == null) {
            SensinactEMFProvider sp;
            Model model = modelMgr.getModel(packageUri, mod);
            if (model == null) {
                model = modelMgr.createModel(packageUri, mod).withCreationTime(this.dataUpdateDto.timestamp).build();
            }
            if (!model.isFrozen()) {
                Resource r;
                Service service = (Service)model.getServices().get(svc);
                if (service == null) {
                    service = (Service)model.createService(svc).withCreationTime(this.dataUpdateDto.timestamp).build();
                }
                if ((r = (Resource)service.getResources().get(res)) == null) {
                    r = (Resource)service.createResource(res).withValueType(ValueType.UPDATABLE).withType(this.dataUpdateDto.type).build();
                }
            }
            if ((sp = twin.getProvider(packageUri, mod, provider)) == null) {
                sp = twin.createProvider(packageUri, mod, provider, this.dataUpdateDto.timestamp);
            }
            resource = (SensinactResource)sp.getOrCreateService(svc, svcEClass).getResources().get(res);
        }
        return resource.setValue(this.dataUpdateDto.data, this.dataUpdateDto.timestamp);
    }
}

